% Generated by roxygen2 (4.0.0): do not edit by hand
\name{download}
\alias{download}
\title{Downloads a resource}
\usage{
download(x, ...)
}
\arguments{
\item{x}{a resource, or object containing resources, which can be downloaded}

\item{...}{optional additional arguments to methods, e.g.:
\itemize{
  \item{message.on.fail}{logical: show message on download failure?}
  \item{message.on.succeed}{logical: show message on download success?}
}}
}
\description{
Downloads a resource
}
\examples{
# query, select a dataset, get its metadata
\dontrun{
result <- searchBerlinDatasets(query = "vornamen")
summary(result)
dataset <- getDatasetMetaData(result[[2]])
summary(dataset)

# pick a resource to download
resource <- resources(dataset)[[23]]
data <- download(resource)
# returns a data.frame
class(data)
# or download multiple resources simultaneously
data <- download(resources(dataset)[1:6])
# returns a list of data.frames
class(data)
class(data[[1]])

# download all resources in dataset
data <- download(dataset)

# turn off individual notifications for failed downloads
# due to unsupported file formats, URL schemes, etc.
data <- download(dataset, message.on.fail=FALSE)

# turn off all individual notifications for downloads
data <- download(dataset, message.on.fail=FALSE, message.on.succeed=FALSE)

# pass in other arguments to download function
result <- searchBerlinDatasets(query = "stolpersteine")
dataset <- getDatasetMetaData(result[[2]])
resource_list <- resources(dataset)
data <- download(resource_list[[1]])
# gives wrong output, so we try a different argument for 'sep'
data <- download(resource_list[[1]], sep=',')
}
}

