bergm <- function(model,burn.in=0,
	main.iter=5000,aux.iter=1000,
	sdprop=NULL,sdprior=50,mprior=0,
	theta=NULL,popMCMC=TRUE,nchains=NULL,
	gamma=1,sdepsilon=0.05,
	save=FALSE){

		
	mod <- ergm.getmodel(model,ergm.getnetwork(model))
    stat <- ergm.getglobalstats(ergm.getnetwork(model),mod)
    mrow <- length(stat)
		

	if(popMCMC==FALSE){
        mcol <- mrow
        H <- matrix(0,main.iter,mrow)
        if (is.null(theta)){ theta <- runif(mrow,max=0.5) }
        if (is.null(sdprop)){ sdprop <- rep(0.1,mrow) }
        nchains <- 1
    }else{
        if (is.null(nchains)){ nchains <- 2 * mrow }
        mcol <- nchains
        H <- matrix(0,main.iter,mrow*mcol)
			if(is.null(theta)){
				theta <- matrix(runif(mrow*mcol,max=0.5),mrow,mcol)
			}else{
				theta <- matrix(theta,mrow,mcol,byrow=FALSE)
			}
    }
		
		
    iter <- burn.in + main.iter
    pr <- rep(0,mrow)
    thetad <- theta
    accept <- rep(0,mcol)
    for (k in 1:iter){
        for (h in 1:mcol){
            if (popMCMC == FALSE){
                thetad[h] <- rnorm(1,theta[h],sdprop[h])
                pr <- dnorm(c(theta,thetad),mprior,sdprior)
                prr <- prod(pr[1:mrow] / pr[1:mrow])
                yd <- simulate(model,theta0=thetad,burnin=aux.iter)
                delta <- ergm.getglobalstats(yd,mod) - stat
                beta <- t(theta - thetad) %*% delta + log(prr)
                if (beta >= log(runif(1))) {
                  theta[h] <- thetad[h]
                  accept[h] <- accept[h] + 1
                }
            }
            else {
                thetad[,h] <- theta[,h] + gamma * 
                    apply(theta[,sample(seq(1,mcol)[-h],2)],1,diff) + 
                    rnorm(mrow,0,sdepsilon)
                pr <- dnorm(c(theta[,h],thetad[,h]),mprior,sdprior)
                prr <- prod(pr[1:mrow] / pr[1:mrow])
                yd <- simulate(model,theta0=thetad[,h],burnin=aux.iter)
                delta <- ergm.getglobalstats(yd, mod) - stat
                beta <- t(theta[,h] - thetad[,h]) %*% delta + log(prr)
					if (beta >= log(runif(1))) {
						theta[, h] <- thetad[,h]
						if (k > burn.in){
							accept[h] <- accept[h] + 1
						}
					}
				}
			}
        if (k > burn.in) H[k-burn.in,] <- theta
    }
    out = list(theta=H,dim=mrow,chains=nchains,iter=main.iter, 
        rate=(accept / main.iter),mod=model)
    if (save == TRUE){ dput(out,"bergm.out") }
    out
}