requireNamespace("dplyr")
library(dplyr) # couldn't use %>% without this


# make some test data - this is derived from GBIF data but it is HEAVILY EDITED and USELESS
testData <- dplyr::tribble( # even step coordinates (different for lat/long)
  ~database_id, ~datasetName,       ~id, ~institutionCode, ~collectionCode,         ~ownerInstitutionCode,                    ~basisOfRecord,                  ~occurrenceID,      ~catalogNumber, ~otherCatalogNumbers,   ~kingdom,      ~phylum,    ~class,        ~order,  ~family,  ~scientificName, ~taxonID, ~scientificNameAuthorship, ~genus, ~specificEpithet,        ~recordedBy, ~eventDate, ~year, ~month, ~day,        ~verbatimEventDate,        ~country, ~stateProvince,  ~locality,                  ~locationRemarks, ~decimalLatitude, ~decimalLongitude, ~minimumElevationInMeters,                                             ~rights,                                     ~rightsHolder, ~accessRights,                                       ~recordId,   ~occurrenceStatus,
  "fake SCAN1", "fakeDataset",    13775122L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0106100",     "casent0106100",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.541,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:46a46727-6535-4e70-88e7-a42c98f806ed",           "PRESENT",
  "fake SCAN2", "fakeDataset",    13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.542,         -121.7568,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",           "PRESENT",
  "fake SCAN3", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.543,         -121.7569,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",           "PRESENT",
  "fake SCAN4", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.544,         -121.7570,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN5", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.545,         -121.7571,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN6", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.546,         -121.7572,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  
  "fake SCAN7", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN8", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN9", "fakeDataset",    13852774L,                      "CAS",        "ANTWEB", "CAS, San Francisco, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0249086",     "casent0249086",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera", "C. Sch‚àö‚àÇning",   "9/1/09", 2009L,     9L,   1L,                "1-Sep-09",         "Kenya",             NA, "Chogoria",                                NA,         -0.20222,           37.5083,                     2277L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:964139d3-fb07-4a57-9b7c-e9a5830f4c82",            "ABSENT",
  "fake SCAN10", "fakeDataset",          NA,                      "CAS",        "ANTWEB",       "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                    NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",     "mellifera",         "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.546,         -121.7572,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",
  "fake SCAN11", "newDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN12", "newDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,         -121.7567,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN13", "newDataset",    13852774L,                      "CAS",        "ANTWEB", "CAS, San Francisco, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0249086",     "casent0249086",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera", "C. Sch‚àö‚àÇning",   "9/1/09", 2009L,     9L,   1L,                "1-Sep-09",         "Kenya",             NA, "Chogoria",                                NA,         -0.20222,           37.5083,                     2277L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:964139d3-fb07-4a57-9b7c-e9a5830f4c82",            "ABSENT",
  
  "fake SCAN14", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN15", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN16", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN17", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Ward",  "4/29/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",            38.54,          -121.756,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  
  "fake SCAN18", "fakeDataset",    13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.742,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",            "ABSENT",
  "fake SCAN19", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.743,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "ABSENT",
  "fake SCAN20", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.744,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",  
  "fake SCAN21", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",         "BeeNerd",  "6/30/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           28.745,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",                     
  
  "fake SCAN22", "fakeDataset",    13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "easterEgg",  "6/30/15", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",          28.7400,        -121.7512,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",            "ABSENT",
  "fake SCAN23", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "easterEgg",  "6/30/15", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",          28.7400,        -121.7513,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",           "PRESENT",
  "fake SCAN24", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "easterEgg",  "6/30/15", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",          28.7400,        -121.7514,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN25", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "easterEgg",  "6/30/15", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",          28.7400,        -121.7515,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,           "PRESENT",
  "fake SCAN26", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "6/28/05", 2005L,     6L,  28L, "28 Jun 2005/29 Jun 2005", "United States",   "California",    "Davis", "coordinates obtained from Label",           38.543,        -121.7569,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "ABSENT",
  # no matching
  "fake SCAN27", "fakeDataset",    13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",           "Yadad",   "14/04/09", 2009L,     4L,  14L,                        "", "United States",   "California",   "Davis", "coordinates obtained from Label",            21.08,          -128.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",            "ABSENT",
  "fake SCAN28", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Yadad",  "21/06/92", 1992L,     6L,  21L,                        "", "United States",   "California",   "Davis", "coordinates obtained from Label",         50.75400,           -12.73,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "ABSENT",
  "fake SCAN29", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Yadad",   "2/06/25", 2025L,     6L,   2L,                        "", "United States",   "California",   "Davis", "coordinates obtained from Label",          13.2400,        -150.7514,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",   
  "fake SCAN30", "fakeDataset",           NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",            "Yadad",   "8/01/00", 2000L,     1L,   8L,                        "", "United States",   "California",   "Davis", "coordinates obtained from Label",        09.712400,       -11.753215,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "ABSENT",             
  "fake SCAN31", "fakeDataset",    13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "P.S. Ward",  "31/12/76", 1876L,    12L,  31L,                        "", "United States",   "California",   "Davis", "coordinates obtained from Label",          38.5423,       -21.752369,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "ABSENT",
  # Too few decimals
  "fake SCAN32", "newDataset",     13775122L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",     "CAS:ANTWEB:casent0106100",     "casent0106100",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "E Fischer",   "6/28/95", 2095L,     6L,  28L, "28 Jun 2095/29 Jun 2095", "United States",   "OuterSpace",   "Davis", "coordinates obtained from Label",           38.54,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:46a46727-6535-4e70-88e7-a42c98f806ed",            "PRESENT",
  "fake SCAN33", "newDataset",     13775123L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d01", "casent0106100-d01",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "E Fischer",   "6/28/95", 2095L,     6L,  28L, "28 Jun 2095/29 Jun 2095", "United States",   "OuterSpace",   "Davis", "coordinates obtained from Label",           38.55,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:d6ff3ddb-4695-4aaf-ab89-c251ab2fc7e6",            "PRESENT",
  "fake SCAN34", "newDataset",     13775124L,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen", "CAS:ANTWEB:casent0106100-d11", "casent0106100-d11",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "E Fischer",   "6/28/95", 2095L,     6L,  28L, "28 Jun 2095/29 Jun 2095", "United States",   "OuterSpace",   "Davis", "coordinates obtained from Label",           38.56,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA, "urn:uuid:4504a6e6-ab1c-4de7-ac43-a3588a63ae90",            "PRESENT",
  "fake SCAN35", "newDataset",            NA,                      "CAS",        "ANTWEB",        "UCDC, Davis, CA, USA", "PreservedSpecimen",                             NA,                  NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "apidae", "apis mellifera",  235783L,          "Linnaeus, 1758", "Apis",      "mellifera",        "E Fischer",   "6/28/95", 2095L,     6L,  28L, "28 Jun 2095/29 Jun 2095", "United States",   "OuterSpace",   "Davis", "coordinates obtained from Label",           38.57,           -121.75,                       15L, "http://creativecommons.org/publicdomain/zero/1.0/", "The California Academy of Sciences - AntWeb.org",            NA,                                              NA,            "PRESENT"
  
)



# Run the function
testOut <- BeeBDC::flagAbsent(data = testData, PresAbs = "occurrenceStatus")


# test number of TRUE and FALSE values in the flag column, .occurrenceAbsent
resultsT <- length(testOut$.occurrenceAbsent[testOut$.occurrenceAbsent == TRUE])
resultsF <- length(testOut$.occurrenceAbsent[testOut$.occurrenceAbsent == FALSE])

testthat::test_that("flagAbsent column .occurrenceAbsent results TRUE", {
  testthat::expect_equal(resultsT, 17)
})

testthat::test_that("flagAbsent column .occurrenceAbsent results FALSE", {
  testthat::expect_equal(resultsF, 18)
})


# test the order of the TRUE and FALSE values in the flag column, .occurrenceAbsent
correct <- c(TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, TRUE, 
             TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
             TRUE, TRUE, TRUE, TRUE)

testthat::test_that("flagAbsent column .occurrenceAbsent results correct series", {
  testthat::expect_equal(correct, testOut$.occurrenceAbsent)
})

