/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;
import org.ejml.data.DenseMatrix64F;

public class WrappedNormalSufficientStatistics {
    private final WrappedVector mean;
    private final WrappedMatrix precision;
    private final WrappedMatrix variance;
    private final double precisionScalar;

    public WrappedNormalSufficientStatistics(WrappedVector wrappedVector, WrappedMatrix wrappedMatrix, WrappedMatrix wrappedMatrix2) {
        this.mean = wrappedVector;
        this.precision = wrappedMatrix;
        this.variance = wrappedMatrix2;
        this.precisionScalar = 1.0;
    }

    public WrappedNormalSufficientStatistics(double[] dArray, int n, int n2, DenseMatrix64F denseMatrix64F, PrecisionType precisionType) {
        int n3 = (n2 + precisionType.getMatrixLength(n2)) * n;
        this.mean = new WrappedVector.Raw(dArray, n3, n2);
        if (precisionType == PrecisionType.SCALAR) {
            this.precision = new WrappedMatrix.Raw(denseMatrix64F.getData(), 0, n2, n2);
            this.precisionScalar = dArray[n3 + n2];
            this.variance = null;
        } else {
            this.precisionScalar = 1.0;
            this.precision = new WrappedMatrix.Raw(dArray, n3 + n2, n2, n2);
            this.variance = new WrappedMatrix.Raw(dArray, n3 + n2 + n2 * n2, n2, n2);
        }
    }

    public WrappedVector getMean() {
        return this.mean;
    }

    public WrappedMatrix getPrecision() {
        return this.precision;
    }

    public WrappedMatrix getVariance() {
        return this.variance;
    }

    public double getMean(int n) {
        return this.mean.get(n);
    }

    public double getPrecision(int n, int n2) {
        return this.precision.get(n, n2);
    }

    public double getPrecisionScalar() {
        return this.precisionScalar;
    }

    public String toString() {
        return this.mean + " " + this.precision;
    }
}

