/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolver;
import no.uib.cipr.matrix.sparse.Preconditioner;

public abstract class AbstractIterativeSolver
implements IterativeSolver {
    protected Preconditioner M = new IdentityPreconditioner();
    protected IterationMonitor iter = new DefaultIterationMonitor();

    public void setPreconditioner(Preconditioner M) {
        this.M = M;
    }

    public Preconditioner getPreconditioner() {
        return this.M;
    }

    public IterationMonitor getIterationMonitor() {
        return this.iter;
    }

    public void setIterationMonitor(IterationMonitor iter) {
        this.iter = iter;
    }

    protected void checkSizes(Matrix A, Vector b, Vector x) {
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (b.size() != A.numRows()) {
            throw new IllegalArgumentException("b.size() != A.numRows()");
        }
        if (b.size() != x.size()) {
            throw new IllegalArgumentException("b.size() != x.size()");
        }
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        public Vector apply(Vector b, Vector x) {
            return x.set(b);
        }

        public Vector transApply(Vector b, Vector x) {
            return x.set(b);
        }

        public void setMatrix(Matrix A) {
        }
    }
}

