/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.EigenVectorsMatrix;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.TransposedMatrixParameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.StringTokenizer;

public class MatrixParameter
extends CompoundParameter
implements MatrixParameterInterface {
    public static final String MATRIX_PARAMETER = "matrixParameter";
    private boolean dimensionsEstablished = false;
    protected int columnDimension = 0;
    protected int rowDimension = 0;
    public static final String ROW_DIMENSION = "rows";
    public static final String COLUMN_DIMENSION = "columns";
    public static final String TRANSPOSE = "transpose";
    public static final String EIGEN = "isEigenVectors";
    public static final String AS_COMPOUND = "asCompoundParameter";
    public static final String BEHAVIOR = "test";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 0, Integer.MAX_VALUE), AttributeRule.newIntegerRule("rows", true), AttributeRule.newIntegerRule("columns", true), AttributeRule.newBooleanRule("transpose", true), AttributeRule.newBooleanRule("isEigenVectors", true), AttributeRule.newBooleanRule("asCompoundParameter", true), AttributeRule.newBooleanRule("test", true)};

        @Override
        public String getParserName() {
            return MatrixParameter.MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            int n2;
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            boolean bl = xMLObject.getAttribute(MatrixParameter.TRANSPOSE, false);
            boolean bl2 = xMLObject.getAttribute(MatrixParameter.AS_COMPOUND, false);
            boolean bl3 = xMLObject.getAttribute(MatrixParameter.EIGEN, false);
            assert (!bl3 || !bl) : "Eigen vector matrix cannot be transposed.";
            if (bl2) {
                CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getChild(0);
                MatrixParameter matrixParameter = bl ? TransposedMatrixParameter.recast(string, compoundParameter) : MatrixParameter.recast(string, compoundParameter);
                return matrixParameter;
            }
            MatrixParameter matrixParameter = !bl ? (!bl3 ? new MatrixParameter(string) : new EigenVectorsMatrix(string)) : new TransposedMatrixParameter(string);
            if (xMLObject.getAttribute(MatrixParameter.BEHAVIOR, false).booleanValue() && xMLObject.hasAttribute(MatrixParameter.ROW_DIMENSION) && xMLObject.hasAttribute(MatrixParameter.COLUMN_DIMENSION)) {
                n2 = xMLObject.getIntegerAttribute(MatrixParameter.ROW_DIMENSION);
                n = xMLObject.getIntegerAttribute(MatrixParameter.COLUMN_DIMENSION);
                matrixParameter.setDimensions(n2, n);
            } else {
                if (xMLObject.hasAttribute(MatrixParameter.ROW_DIMENSION)) {
                    n2 = xMLObject.getIntegerAttribute(MatrixParameter.ROW_DIMENSION);
                    matrixParameter.setRowDimension(n2);
                }
                if (xMLObject.hasAttribute(MatrixParameter.COLUMN_DIMENSION)) {
                    n2 = xMLObject.getIntegerAttribute(MatrixParameter.COLUMN_DIMENSION);
                    matrixParameter.setColumnDimension(n2);
                }
            }
            n2 = 0;
            for (n = 0; n < xMLObject.getChildCount(); ++n) {
                Parameter parameter = (Parameter)xMLObject.getChild(n);
                matrixParameter.addParameter(parameter);
                if (n == 0) {
                    n2 = parameter.getDimension();
                    continue;
                }
                if (n2 == parameter.getDimension()) continue;
                throw new XMLParseException("All parameters must have the same dimension to construct a rectangular matrix");
            }
            return matrixParameter;
        }

        @Override
        public String getParserDescription() {
            return "A matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MatrixParameter.class;
        }
    };

    public MatrixParameter(String string) {
        super(string);
    }

    public MatrixParameter(String string, Parameter[] parameterArray) {
        super(string, parameterArray);
        this.rowDimension = parameterArray[0].getDimension();
        this.columnDimension = parameterArray.length;
        this.dimensionsEstablished = true;
    }

    public MatrixParameter(String string, int n, int n2) {
        super(string);
        this.setDimensions(n, n2);
    }

    public MatrixParameter(String string, int n, int n2, double d) {
        super(string);
        this.setDimensions(n, n2, d);
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        this.getParameter(n2).setParameterValue(n, d);
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        this.getParameter(n2).setParameterValueQuietly(n, d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        this.getParameter(n2).setParameterValueNotifyChangedAll(n, d);
    }

    public static MatrixParameter recast(String string, CompoundParameter compoundParameter) {
        int n = compoundParameter.getParameterCount();
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = compoundParameter.getParameter(i);
        }
        return new MatrixParameter(string, parameterArray);
    }

    @Override
    public double getParameterValue(int n, int n2) {
        return this.getParameter(n2).getParameterValue(n);
    }

    public double[] getRowValues(int n) {
        int n2 = this.getColumnDimension();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.getParameterValue(n, i);
        }
        return dArray;
    }

    @Override
    public double[] getColumnValues(int n) {
        return this.getParameter(n).getParameterValues();
    }

    @Override
    public double[][] getParameterAsMatrix() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    public void setColumnDimension(int n) {
        if (this.dimensionsEstablished) {
            throw new IllegalArgumentException("Attempt to change dimensions after initialization");
        }
        this.columnDimension = n;
        this.setupParameters();
    }

    public void setRowDimension(int n) {
        if (this.dimensionsEstablished) {
            throw new IllegalArgumentException("Attempt to change dimensions after initialization");
        }
        this.rowDimension = n;
        this.setupParameters();
    }

    private void setupParameters() {
        if (this.columnDimension > 0 && this.rowDimension > 0) {
            this.dimensionsEstablished = true;
            for (int i = 0; i < this.rowDimension; ++i) {
                Parameter.Default default_ = new Parameter.Default(this.columnDimension, 0.0);
                default_.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.columnDimension));
                this.addParameter(default_);
            }
        }
    }

    public void setDimensions(int n, int n2) {
        this.setDimensions(n, n2, 0.0);
    }

    public void setDimensions(int n, int n2, double d) {
        this.rowDimension = n;
        this.columnDimension = n2;
        for (int i = 0; i < n2; ++i) {
            Parameter.Default default_ = new Parameter.Default(n, d);
            default_.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, n));
            this.addParameter(default_);
        }
    }

    @Override
    public int getColumnDimension() {
        return this.getParameterCount();
    }

    @Override
    public int getRowDimension() {
        return this.getParameter(0).getDimension();
    }

    @Override
    public int getUniqueParameterCount() {
        return this.getParameterCount();
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return super.getParameter(n);
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        int n2 = this.getDimension();
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getParameterValue(i);
        }
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        for (int i = 0; i < this.getDimension(); ++i) {
            this.setParameterValueQuietly(i, dArray[n + i]);
        }
    }

    public static String toSymmetricString(MatrixParameterInterface matrixParameterInterface) {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = matrixParameterInterface.getRowDimension();
        int n2 = n * (n + 1) / 2;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                stringBuilder.append(String.format("%5.4e", matrixParameterInterface.getParameterValue(i, j)));
                if (--n2 <= 0) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    public static MatrixParameter parseFromSymmetricString(String string) {
        int n;
        String string2 = string.replace("{", "").replace("}", "").trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n2 = stringTokenizer.countTokens();
        int n3 = (-1 + (int)Math.sqrt(1 + 8 * n2)) / 2;
        Parameter[] parameterArray = new Parameter[n3];
        for (n = 0; n < n3; ++n) {
            parameterArray[n] = new Parameter.Default(n3);
        }
        for (n = 0; n < n3; ++n) {
            for (int i = n; i < n3; ++i) {
                double d = new Double(stringTokenizer.nextToken());
                parameterArray[n].setParameterValue(i, d);
                parameterArray[i].setParameterValue(n, d);
            }
        }
        return new MatrixParameter(null, parameterArray);
    }

    public static MatrixParameter parseFromSymmetricDoubleArray(Object[] objectArray) {
        int n;
        int n2 = (-1 + (int)Math.sqrt(1 + 8 * objectArray.length)) / 2;
        Parameter[] parameterArray = new Parameter[n2];
        for (n = 0; n < n2; ++n) {
            parameterArray[n] = new Parameter.Default(n2);
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i; j < n2; ++j) {
                double d = (Double)objectArray[n++];
                parameterArray[i].setParameterValue(j, d);
                parameterArray[j].setParameterValue(i, d);
            }
        }
        return new MatrixParameter(null, parameterArray);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    public void rowMultiply(double d, int n) {
        this.rowMultiplyQuietly(d, n);
        this.fireParameterChangedEvent();
    }

    public void columnMultiply(double d, int n) {
        this.columnMultiplyQuietly(d, n);
        this.fireParameterChangedEvent();
    }

    public TransposedMatrixParameter transpose() {
        return TransposedMatrixParameter.recast(null, this);
    }

    public MatrixParameter add(MatrixParameter matrixParameter) {
        if (matrixParameter.getRowDimension() != this.getRowDimension() || this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("You cannot add a " + this.getRowDimension() + " by " + this.getColumnDimension() + " matrix to a " + matrixParameter.getRowDimension() + " by " + matrixParameter.getColumnDimension() + " matrix.");
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getRowDimension(), this.getColumnDimension());
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                matrixParameter2.setParameterValueQuietly(i, j, this.getParameterValue(i, j) + matrixParameter.getParameterValue(i, j));
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter addInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (matrixParameter.getRowDimension() != this.getRowDimension() || this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("You cannot add a " + this.getRowDimension() + " by " + this.getColumnDimension() + " matrix to a " + matrixParameter.getRowDimension() + " by " + matrixParameter.getColumnDimension() + " matrix.");
        }
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                matrixParameter2.setParameterValueQuietly(i, j, this.getParameterValue(i, j) + matrixParameter.getParameterValue(i, j));
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter subtract(MatrixParameter matrixParameter) {
        if (matrixParameter.getRowDimension() != this.getRowDimension() || this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("You cannot subtract a " + this.getRowDimension() + " by " + this.getColumnDimension() + " matrix to a " + matrixParameter.getRowDimension() + " by " + matrixParameter.getColumnDimension() + " matrix.");
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getRowDimension(), this.getColumnDimension());
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                matrixParameter2.setParameterValueQuietly(i, j, this.getParameterValue(i, j) - matrixParameter.getParameterValue(i, j));
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter subtractInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (matrixParameter.getRowDimension() != this.getRowDimension() || this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("You cannot subtract a " + this.getRowDimension() + " by " + this.getColumnDimension() + " matrix from a " + matrixParameter.getRowDimension() + " by " + matrixParameter.getColumnDimension() + " matrix.");
        }
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                matrixParameter2.setParameterValueQuietly(i, j, this.getParameterValue(i, j) - matrixParameter.getParameterValue(i, j));
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter transposeThenProduct(MatrixParameter matrixParameter) {
        if (this.getRowDimension() != matrixParameter.getRowDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getRowDimension() + " does not equal " + this.getRowDimension() + ".\n");
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getColumnDimension(), matrixParameter.getColumnDimension());
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        int n3 = matrixParameter.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(k, i) * matrixParameter.getParameterValue(k, j);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter transposeThenProductInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (this.getRowDimension() != matrixParameter.getRowDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getRowDimension() + " does not equal " + this.getRowDimension() + ".\n");
        }
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        int n3 = matrixParameter.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(k, i) * matrixParameter.getParameterValue(k, j);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter product(MatrixParameter matrixParameter) {
        if (this.getColumnDimension() != matrixParameter.getRowDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getRowDimension() + " does not equal " + this.getColumnDimension() + ".\n");
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getRowDimension(), matrixParameter.getColumnDimension());
        int n = this.getColumnDimension();
        int n2 = this.getRowDimension();
        int n3 = matrixParameter.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(i, k) * matrixParameter.getParameterValue(k, j);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter productInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (this.getColumnDimension() != matrixParameter.getRowDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getRowDimension() + " does not equal " + this.getColumnDimension() + ".\n");
        }
        int n = this.getColumnDimension();
        int n2 = this.getRowDimension();
        int n3 = matrixParameter.getColumnDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(i, k) * matrixParameter.getParameterValue(k, j);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter productWithTransposed(MatrixParameter matrixParameter) {
        if (this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getColumnDimension() + " does not equal " + this.getColumnDimension() + ".\n");
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getRowDimension(), matrixParameter.getRowDimension());
        int n = this.getColumnDimension();
        int n2 = this.getRowDimension();
        int n3 = matrixParameter.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(i, k) * matrixParameter.getParameterValue(j, k);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public MatrixParameter productWithTransposedInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (this.getColumnDimension() != matrixParameter.getColumnDimension()) {
            throw new RuntimeException("Incompatible Dimensions: " + matrixParameter.getColumnDimension() + " does not equal " + this.getColumnDimension() + ".\n");
        }
        int n = this.getColumnDimension();
        int n2 = this.getRowDimension();
        int n3 = matrixParameter.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += this.getParameterValue(i, k) * matrixParameter.getParameterValue(j, k);
                }
                matrixParameter2.setParameterValueQuietly(i, j, d);
            }
        }
        return matrixParameter2;
    }

    public void product(double d) {
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                this.setParameterValueQuietly(i, j, d * this.getParameterValue(i, j));
            }
        }
        this.fireParameterChangedEvent();
    }

    public MatrixParameter productInPlace(double d, MatrixParameter matrixParameter) {
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                matrixParameter.setParameterValueQuietly(i, j, d * this.getParameterValue(i, j));
            }
        }
        return matrixParameter;
    }

    public void rowMultiplyQuietly(double d, int n) {
        for (int i = 0; i < this.getColumnDimension(); ++i) {
            if (this.getParameter(i).getDimension() >= n) continue;
            this.getParameter(i).setParameterValueQuietly(n, d * this.getParameterValue(n, i));
        }
    }

    public void columnMultiplyQuietly(double d, int n) {
        Parameter parameter = this.getParameter(n);
        for (int i = 0; i < parameter.getDimension(); ++i) {
            parameter.setParameterValueQuietly(i, d * parameter.getParameterValue(i));
        }
    }
}

