/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.alignment.Alignment;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.HiddenLinkageModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.HashSet;

public class LinkageGroupSwap
extends SimpleMCMCOperator {
    HiddenLinkageModel hlm;
    int groupCount;
    int columnCount;
    public static XMLObjectParser LINKAGE_GROUP_SWAP_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(HiddenLinkageModel.class)};

        @Override
        public String getParserName() {
            return "linkageGroupSwap";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            HiddenLinkageModel hiddenLinkageModel = (HiddenLinkageModel)xMLObject.getChild(HiddenLinkageModel.class);
            double d = xMLObject.getDoubleAttribute("weight");
            return new LinkageGroupSwap(hiddenLinkageModel, d);
        }

        @Override
        public String getParserDescription() {
            return "This element represents an operator that swaps taxa among two linkage groups. ";
        }

        @Override
        public Class getReturnType() {
            return LinkageGroupSwap.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public LinkageGroupSwap(HiddenLinkageModel hiddenLinkageModel, double d) {
        this.hlm = hiddenLinkageModel;
        this.groupCount = hiddenLinkageModel.getLinkageGroupCount();
        this.columnCount = hiddenLinkageModel.getData().getAlignment().getSiteCount();
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        if (MathUtils.nextBoolean()) {
            int n = MathUtils.nextInt(this.groupCount);
            int n2 = MathUtils.nextInt(this.groupCount);
            HashSet<Taxon> hashSet = new HashSet<Taxon>(this.hlm.getGroup(n));
            HashSet<Taxon> hashSet2 = new HashSet<Taxon>(this.hlm.getGroup(n2));
            for (Taxon taxon : hashSet) {
                this.hlm.moveReadGroup(taxon, n, n2);
            }
            for (Taxon taxon : hashSet2) {
                this.hlm.moveReadGroup(taxon, n2, n);
            }
        } else {
            ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
            ArrayList<Taxon> arrayList2 = new ArrayList<Taxon>();
            int n = 0;
            int n3 = 0;
            while (arrayList.size() == 0 && arrayList2.size() == 0) {
                int n4 = MathUtils.nextInt(this.columnCount);
                n = MathUtils.nextInt(this.groupCount);
                if (n == (n3 = MathUtils.nextInt(this.groupCount))) continue;
                Alignment alignment = this.hlm.getData().getAlignment();
                for (int i = 0; i < alignment.getTaxonCount(); ++i) {
                    int n2 = alignment.getPatternState(i, n4);
                    if (n2 == this.hlm.getDataType().getGapState() || n2 == this.hlm.getDataType().getUnknownState()) continue;
                    if (this.hlm.getGroup(n).contains(alignment.getTaxon(i))) {
                        arrayList.add(alignment.getTaxon(i));
                    }
                    if (!this.hlm.getGroup(n3).contains(alignment.getTaxon(i))) continue;
                    arrayList2.add(alignment.getTaxon(i));
                }
            }
            for (Taxon taxon : arrayList) {
                this.hlm.moveReadGroup(taxon, n, n3);
            }
            for (Taxon taxon : arrayList2) {
                this.hlm.moveReadGroup(taxon, n3, n);
            }
        }
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "linkageGroupSwap";
    }

    public String getPerformanceSuggestion() {
        return "Ask Aaron Darling to write a better operator";
    }
}

