/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.math.MathUtils;
import dr.stats.DiscreteStatistics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import no.uib.cipr.matrix.BandCholesky;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.SymmTridiagMatrix;
import no.uib.cipr.matrix.UpperSPDBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;

public class GaussianProcessSkytrackParser {
    private static final int changepointsIndex = 5;
    private static final int GvaluesIndex = 6;
    private static final int lambdaBoundIndex = 7;
    private static final int precisionIndex = 8;
    private static final int tmrcaIndex = 10;

    public static void main(String[] stringArray) {
        int n = 101;
        double d = 0.5;
        String string = "examples/hcvNew2small.log";
        CSVstats cSVstats = GaussianProcessSkytrackParser.parseCSV(string, 3);
        double d2 = DiscreteStatistics.quantile(d, cSVstats.tmrcas);
        System.out.println(d2);
        double[] dArray = new double[n];
        double d3 = d2 / (double)(n - 1);
        dArray[0] = 0.001;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = dArray[i - 1] + d3;
        }
        double[] dArray2 = GaussianProcessSkytrackParser.gpPosterior(cSVstats, dArray, cSVstats.getSize() - 1);
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = 1.0 / dArray2[i];
        }
        System.out.println(Arrays.toString(dArray));
        System.out.println(Arrays.toString(dArray3));
    }

    public static CSVstats parseCSV(String string, int n) {
        CSVstats cSVstats = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n2 = 0;
            ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
            ArrayList<ArrayList<Double>> arrayList2 = new ArrayList<ArrayList<Double>>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n2 >= n) {
                    String[] stringArray = string2.split("\t");
                    arrayList.add(GaussianProcessSkytrackParser.parseListStr(stringArray[5]));
                    arrayList2.add(GaussianProcessSkytrackParser.parseListStr(stringArray[6]));
                    arrayList3.add(new Double(stringArray[7]));
                    arrayList4.add(new Double(stringArray[8]));
                    arrayList5.add(new Double(stringArray[10]));
                }
                ++n2;
            }
            cSVstats = new CSVstats(arrayList, arrayList2, arrayList3, arrayList4, arrayList5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cSVstats;
    }

    public static double[] gpPosterior(CSVstats cSVstats, double[] dArray, int n) {
        double[] dArray2 = cSVstats.changepoints.get(n);
        DenseVector denseVector = new DenseVector(cSVstats.Gvalues.get(n));
        double d = cSVstats.precisions[n];
        TripGP tripGP = GaussianProcessSkytrackParser.getGPvalues(dArray2, denseVector, dArray, d);
        double[] dArray3 = GaussianProcessSkytrackParser.sigmoidal(tripGP.getData());
        double[] dArray4 = new double[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray4[i] = dArray3[i] * cSVstats.lambdas[n];
        }
        return dArray4;
    }

    public static TripGP getGPvalues(double[] dArray, DenseVector denseVector, double[] dArray2, double d) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n + n2;
        QuadupleGP quadupleGP = GaussianProcessSkytrackParser.sortUpdate(dArray, dArray2);
        int[] nArray = GaussianProcessSkytrackParser.neighbors(quadupleGP.getPositionNew(), n3);
        DenseVector denseVector2 = new DenseVector(GaussianProcessSkytrackParser.SubsetData(quadupleGP.getData(), nArray));
        SymmTridiagMatrix symmTridiagMatrix = GaussianProcessSkytrackParser.getQmatrix(d, denseVector2);
        int[] nArray2 = GaussianProcessSkytrackParser.SubsetData(quadupleGP.getOrder(), nArray);
        PairIndex pairIndex = GaussianProcessSkytrackParser.SubIndex(nArray2, n, n2);
        UpperSPDBandMatrix upperSPDBandMatrix = new UpperSPDBandMatrix(Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderNew()), 1);
        BandCholesky bandCholesky = new BandCholesky(n2, 1, true);
        bandCholesky.factor(upperSPDBandMatrix);
        DenseVector denseVector3 = new DenseVector(n2);
        int[] nArray3 = GaussianProcessSkytrackParser.SubsetData(nArray2, pairIndex.getOrderOld());
        DenseVector denseVector4 = new DenseVector(GaussianProcessSkytrackParser.SubsetData(denseVector, nArray3));
        Matrix matrix = Matrices.getSubMatrix(symmTridiagMatrix, pairIndex.getOrderNew(), pairIndex.getOrderOld());
        matrix.mult(-1.0, denseVector4, denseVector3);
        DenseVector denseVector5 = new DenseVector(GaussianProcessSkytrackParser.getMultiNormalMean(denseVector3, bandCholesky.getU()));
        double[] dArray3 = GaussianProcessSkytrackParser.getMultiNormal(denseVector5, bandCholesky.getU()).getData();
        return new TripGP(dArray3, quadupleGP.getOrder(), quadupleGP.getPositionNew());
    }

    private static DenseVector getMultiNormalMean(DenseVector denseVector, UpperTriangBandMatrix upperTriangBandMatrix) {
        DenseVector denseVector2 = new DenseVector(denseVector.size());
        DenseVector denseVector3 = new DenseVector(denseVector.size());
        upperTriangBandMatrix.transSolve(denseVector, denseVector2);
        upperTriangBandMatrix.solve(denseVector2, denseVector3);
        return denseVector3;
    }

    private static DenseVector getMultiNormal(DenseVector denseVector, UpperTriangBandMatrix upperTriangBandMatrix) {
        int n = denseVector.size();
        DenseVector denseVector2 = new DenseVector(n);
        for (int i = 0; i < n; ++i) {
            denseVector2.set(i, MathUtils.nextGaussian());
        }
        DenseVector denseVector3 = new DenseVector(denseVector.size());
        upperTriangBandMatrix.solve(denseVector2, denseVector3);
        denseVector3.add(denseVector);
        return denseVector3;
    }

    private static double[] SubsetData(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    private static double[] SubsetData(DenseVector denseVector, int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = denseVector.get(nArray[i]);
        }
        return dArray;
    }

    private static int[] SubsetData(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    private static ArrayList<Double> parseListStr(String string) {
        String[] stringArray;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (String string2 : stringArray = string.replaceAll("\\{|}", "").split(",")) {
            arrayList.add(new Double(string2));
        }
        return arrayList;
    }

    private static double sigmoidal(double d) {
        return 1.0 / (1.0 + Math.exp(-d));
    }

    private static double[] sigmoidal(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = GaussianProcessSkytrackParser.sigmoidal(dArray[i]);
        }
        return dArray2;
    }

    private static int[] neighbors(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[n];
        int n3 = 0;
        int[] nArray3 = new int[n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            if (n4 - 1 > 0) {
                int n5 = n4 - 1;
                nArray2[n5] = nArray2[n5] + 1;
            }
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + 1;
            if (n4 + 1 >= n) continue;
            int n7 = n4 + 1;
            nArray2[n7] = nArray2[n7] + 1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray2[n2] <= 0) continue;
            nArray3[n3] = n2;
            ++n3;
        }
        int[] nArray4 = new int[n3];
        System.arraycopy(nArray3, 0, nArray4, 0, n3);
        return nArray4;
    }

    private static SymmTridiagMatrix getQmatrix(double d, DenseVector denseVector) {
        double d2 = 0.0;
        double[] dArray = new double[denseVector.size() - 1];
        double[] dArray2 = new double[denseVector.size()];
        for (int i = 0; i < denseVector.size() - 1; ++i) {
            dArray[i] = d * (-1.0 / (denseVector.get(i + 1) - denseVector.get(i)));
            if (i >= denseVector.size() - 2) continue;
            dArray2[i + 1] = -dArray[i] + d * (1.0 / (denseVector.get(i + 2) - denseVector.get(i + 1)) + d2);
        }
        dArray2[0] = -dArray[0] + d * d2;
        dArray2[denseVector.size() - 1] = -dArray[denseVector.size() - 2] + d * d2;
        SymmTridiagMatrix symmTridiagMatrix = new SymmTridiagMatrix(dArray2, dArray);
        return symmTridiagMatrix;
    }

    private static SymmTridiagMatrix getQmatrix(double d, double[] dArray) {
        double d2 = 1.0E-11;
        double[] dArray2 = new double[dArray.length - 1];
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray2[i] = d * (-1.0 / (dArray[i + 1] - dArray[i]));
            if (i >= dArray.length - 2) continue;
            dArray3[i + 1] = -dArray2[i] + d * (1.0 / (dArray[i + 2] - dArray[i + 1]) + d2);
        }
        dArray3[0] = -dArray2[0] + d * d2;
        dArray3[dArray.length - 1] = -dArray2[dArray.length - 2] + d * d2;
        SymmTridiagMatrix symmTridiagMatrix = new SymmTridiagMatrix(dArray3, dArray2);
        return symmTridiagMatrix;
    }

    private static QuadupleGP sortUpdate(double[] dArray, double[] dArray2) {
        int n = dArray.length + dArray2.length;
        double[] dArray3 = new double[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[dArray2.length];
        int[] nArray3 = new int[dArray.length];
        int n2 = dArray.length;
        double d = dArray2[0];
        double d2 = dArray[0];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (n2 < n && n3 < dArray.length) {
                d2 = dArray[n3];
                d = dArray2[n2 - dArray.length];
                if (d2 < d) {
                    dArray3[i] = d2;
                    nArray[i] = n3;
                    nArray3[n3] = i;
                    ++n3;
                    continue;
                }
                dArray3[i] = d;
                nArray[i] = n2;
                nArray2[n2 - dArray.length] = i;
                ++n2;
                continue;
            }
            if (n2 < n) {
                dArray3[i] = dArray2[n2 - dArray.length];
                nArray[i] = n2;
                nArray2[n2 - dArray.length] = i;
                ++n2;
                continue;
            }
            dArray3[i] = dArray[n3];
            nArray[i] = n3;
            nArray3[n3] = i;
            ++n3;
        }
        return new QuadupleGP(dArray3, nArray, nArray2, nArray3);
    }

    private static PairIndex SubIndex(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) {
                nArray2[n3] = i;
                ++n3;
                continue;
            }
            nArray3[n4] = i;
            ++n4;
        }
        int[] nArray4 = new int[n4];
        System.arraycopy(nArray3, 0, nArray4, 0, n4);
        return new PairIndex(nArray2, nArray4);
    }

    private static class PairIndex {
        private int[] orderNew;
        private int[] orderOld;

        public PairIndex(int[] nArray, int[] nArray2) {
            this.orderNew = nArray;
            this.orderOld = nArray2;
        }

        public int[] getOrderNew() {
            return this.orderNew;
        }

        public int[] getOrderOld() {
            return this.orderOld;
        }
    }

    private static class QuadupleGP {
        private double[] data;
        private int[] order;
        private int[] positionNew;
        private int[] positionOld;

        public QuadupleGP(double[] dArray, int[] nArray, int[] nArray2, int[] nArray3) {
            this.data = dArray;
            this.order = nArray;
            this.positionNew = nArray2;
            this.positionOld = nArray3;
        }

        public double[] getData() {
            return this.data;
        }

        public int[] getOrder() {
            return this.order;
        }

        public int[] getPositionNew() {
            return this.positionNew;
        }

        public int[] getPositionOld() {
            return this.positionOld;
        }
    }

    private static class TripGP {
        private double[] data;
        private int[] order;
        private int[] newOrder;

        public TripGP(double[] dArray, int[] nArray, int[] nArray2) {
            this.data = dArray;
            this.order = nArray;
            this.newOrder = nArray2;
        }

        public double[] getData() {
            return this.data;
        }

        public int[] getOrder() {
            return this.order;
        }

        public int[] getNewOrder() {
            return this.newOrder;
        }
    }

    private static class CSVstats {
        public ArrayList<double[]> changepoints = new ArrayList();
        public ArrayList<double[]> Gvalues;
        public double[] lambdas;
        public double[] precisions;
        public double[] tmrcas;

        public CSVstats(ArrayList<ArrayList<Double>> arrayList, ArrayList<ArrayList<Double>> arrayList2, ArrayList<Double> arrayList3, ArrayList<Double> arrayList4, ArrayList<Double> arrayList5) {
            int n;
            int n2;
            double[] dArray;
            for (ArrayList<Double> arrayList6 : arrayList) {
                dArray = new double[arrayList6.size()];
                for (n2 = 0; n2 < arrayList6.size(); ++n2) {
                    dArray[n2] = arrayList6.get(n2);
                }
                this.changepoints.add(dArray);
            }
            this.Gvalues = new ArrayList();
            for (ArrayList<Double> arrayList6 : arrayList2) {
                dArray = new double[arrayList6.size()];
                for (n2 = 0; n2 < arrayList6.size(); ++n2) {
                    dArray[n2] = arrayList6.get(n2);
                }
                this.Gvalues.add(dArray);
            }
            this.lambdas = new double[arrayList3.size()];
            for (n = 0; n < arrayList3.size(); ++n) {
                this.lambdas[n] = arrayList3.get(n);
            }
            this.precisions = new double[arrayList4.size()];
            for (n = 0; n < arrayList4.size(); ++n) {
                this.precisions[n] = arrayList4.get(n);
            }
            this.tmrcas = new double[arrayList5.size()];
            for (n = 0; n < arrayList5.size(); ++n) {
                this.tmrcas[n] = arrayList5.get(n);
            }
        }

        public int getSize() {
            int n = -1;
            if (this.changepoints.size() == this.Gvalues.size() && this.changepoints.size() == this.precisions.length && this.changepoints.size() == this.tmrcas.length) {
                n = this.changepoints.size();
            }
            return n;
        }
    }
}

