% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classPrior.R
\name{createPriorDensity}
\alias{createPriorDensity}
\title{Fits a density function to a multivariate sample}
\usage{
createPriorDensity(sampler, method = "multivariate", eps = 1e-10,
  lower = NULL, upper = NULL, best = NULL, ...)
}
\arguments{
\item{sampler}{an object of class BayesianOutput or a matrix}

\item{method}{method to generate prior - default and currently only option is multivariate}

\item{eps}{numerical precision to avoid singularity}

\item{lower}{vector with lower bounds of parameter for the new prior, independent of the input sample}

\item{upper}{vector with upper bounds of parameter for the new prior, independent of the input sample}

\item{best}{vector with "best" values of parameter for the new prior, independent of the input sample}

\item{...}{parameters to pass on to the getSample function}
}
\description{
Fits a density function to a multivariate sample
}
\details{
This function fits a density estimator to a multivariate (typically a posterior) sample. The main purpose is to summarize a posterior sample as a pdf, in order to include it as a prior in a new analysis, for example when new data becomes available, or to calculate a fractional Bayes factor (see \code{\link{marginalLikelihood}}).

The limitation of this function is that we currently only implement a multivariate normal density estimator, so you will have a loss of information if your posterior is not approximately multivariate normal, which is likely the case if you have weak data. Extending the function to include more flexible density estimators (e.g. gaussian processes) is on our todo list, but it's quite tricky to get this stable, so I'm not sure when we will have this working. In general, creating reliable empirical density estimates in high-dimensional parameter spaces is extremely tricky, regardless of the software you are using. 
 
For that reason, it is usually recommended to not update the posterior with this option, but rather:

1. If the full dataset is available, to make a single, or infrequent updates, recompute the entire model with the full / updated data

2. For frequent updates, consider using SMC instead of MCMC sampling. SMC sampling doesn't require an analytical summary of the posterior.
}
\examples{
# Create a BayesianSetup
ll <- generateTestDensityMultiNormal(sigma = "no correlation")
bayesianSetup = createBayesianSetup(likelihood = ll, 
                                    lower = rep(-10, 3), 
                                    upper = rep(10, 3))

settings = list(iterations = 1000)
out <- runMCMC(bayesianSetup = bayesianSetup, settings = settings)


newPrior = createPriorDensity(out, method = "multivariate",
                              eps = 1e-10, lower = rep(-10, 3),
                              upper =  rep(10, 3), best = NULL)

bayesianSetup <- createBayesianSetup(likelihood = ll, prior = newPrior)

\dontrun{
  settings = list(iterations = 1000)
  out <- runMCMC(bayesianSetup = bayesianSetup, settings = settings)
}



}
\seealso{
\code{\link{createPrior}} \cr
         \code{\link{createBetaPrior}} \cr
         \code{\link{createTruncatedNormalPrior}} \cr
         \code{\link{createUniformPrior}} \cr
         \code{\link{createBayesianSetup}} \cr
}
\author{
Florian Hartig
}
