% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticsGelman.R
\name{gelmanDiagnostics}
\alias{gelmanDiagnostics}
\title{Runs Gelman Diagnotics over an BayesianOutput}
\usage{
gelmanDiagnostics(sampler, thin = "auto", plot = F, ...)
}
\arguments{
\item{sampler}{an object of class mcmcSampler or mcmcSamplerList}

\item{thin}{parameter determining the thinning intervall. Either an integer or "auto" (default) for automatic thinning.}

\item{plot}{should a Gelman plot be generated}

\item{...}{further arguments passed to \code{\link{getSample}}}
}
\description{
Runs Gelman Diagnotics over an BayesianOutput
}
\details{
The function calls the coda package to calculate Gelman diagnostics and plots

The original idea is that this function is applied to the outcome of several independent MCMC runs. Technically and practically, it can also be applied to a single MCMC run that has several internal chains, such as DE, DEzs, DREAM, DREAMzs or T-Walk. As argued in ter Braak et al. (2008), the internal chains should be independent after burn-in. While this is likely correct, it also means that they are not completely independent before, and we observed this behavior in the use of the algorithms (i.e. that internal DEzs chains are more similar to each other than the chains of independent DEzs algorithms). A concern is that this non-independence could lead to a failure to detect that the sampler hasn't converged yet. We would therefore recommend to run several DEzs and check convergence with those, instead of running only one.  

ter Braak, Cajo JF, and Jasper A. Vrugt. "Differential evolution Markov chain with snooker updater and fewer chains." Statistics and Computing 18.4 (2008): 435-446.
}
