% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_analyzeResults.R
\name{Run_analyzeResults}
\alias{Run_analyzeResults}
\title{Run Analyze Results with Specified Data and Options}
\usage{
Run_analyzeResults(
  data_file_location,
  option_file,
  excel_file,
  output_path = NULL
)
}
\arguments{
\item{data_file_location}{The location of the data file which is generated after \code{Run_MCMC}.}

\item{option_file}{The name of the option file (e.g., "option1.R") located in the current working directory.}

\item{excel_file}{The path to an Excel file containing additional data. This parameter is required and must be a valid path to an existing file.}

\item{output_path}{Directory where the output will be saved. If \code{NULL}, a temporary directory will be created and used.}
}
\value{
None. The function executes the analysis and saves the results to the specified \code{output_path}.
}
\description{
This function performs an analysis based on the specified data file, option_file, Excel file, and it saves the results in the output_path.
It loads auxiliary data, executes analysis steps, and saves the results.
}
\examples{
# Define file paths
data_file <- system.file("extdata", 
                          package = "BayesianFitForecast")
option_file <- system.file("extdata", "option.R", 
                          package = "BayesianFitForecast")
                                                     
excel_file <- system.file("extdata", "SanFrancisco.xlsx", 
                          package = "BayesianFitForecast")  
# Run the analysis
\donttest{
Run_analyzeResults(
  data_file = data_file, 
  option_file = option_file, 
  excel_file = excel_file, 
  output_path = NULL)
}

# Results are saved in the specified directory or temporary directory if none is provided.
}
