% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_of_hit_and_false_alarms_from_vector.R
\name{array_of_hit_and_false_alarms_from_vector}
\alias{array_of_hit_and_false_alarms_from_vector}
\title{Array of hits and false alarms; 2019 Jun 18}
\usage{
array_of_hit_and_false_alarms_from_vector(dataList)
}
\arguments{
\item{dataList}{A list, consisting of the following \R objects:\code{m,q,c,h,f,NL,C,M,Q} each of which means from the right

\code{m } : A vector, indicating the modality ID = 1,2,... which does not include zero.

\code{q } : A vector, indicating the reader ID = 1,2,... which does not include zero.

\code{c }  : A vector, indicating the confidence = 1,2,... which does not include zero.

\code{h }  : A vector, indicating the number of hits

\code{f }  : A vector, indicating the number of false alarm

\code{NL }  : A positive integer, indicating the number of lesions for all images

\code{C } : A positive integer, indicating the highest number of confidence level

\code{M } : A positive integer, indicating the number of modalities

\code{Q } : A positive integer, indicating the number of readers.

The detail of these dataset, please see the example datasets, e.g. \code{\link{dd}}.}
}
\value{
A list,
 whose components are arrays of the number of hits  \code{h} and
  the number of false alarms \code{f} of dimension \code{ [c,M,Q]}.
   Do not confuse \code{ [c,Q,M]} or \code{ [M,Q,C]}, etc.
  Revised 2019 Nov. 20
}
\description{
Return value is a three dimensional array of
type \strong{\emph{[C,M,Q]}}
representing the number of confidence levels
and modalities and readers,
 respectively.
This array includes the number of hit
and the number of false alarms.


 Revised 2019 Nov. 20
}
\details{
The author also implemented this
in the \code{ \link{metadata_to_fit_MRMC}} which is an old version.
However, the old version uses "\code{for}" sentences,
and it is not so better.
On the other hand,
this function use
the function \code{\link[base]{aperm}}()
and   \code{\link[base]{array}}() and they are better
than "\code{for}" sentence.

Revised 2019 Nov. 20
Revised 2019 Dec. 12
}
\examples{
#--------------------------------------------------------------------------------------
#                        Validation of program
#--------------------------------------------------------------------------------------


 h1 <- array_of_hit_and_false_alarms_from_vector(dd)$harray
 h2 <- metadata_to_fit_MRMC(dd)$harray

 h1 == h2




 f1 <- array_of_hit_and_false_alarms_from_vector(dd)$farray
 f2 <- metadata_to_fit_MRMC(dd)$farray

 f1 == f2

#--------------------------------------------------------------------------------------
#                       subtraction for ( hit - hit.expected)
#--------------------------------------------------------------------------------------
# In the chi square calculation,
# we need to subtract expected value of hit from hit rate,
# thus the author made this function.


\dontrun{


# Prepare example data

    dd <- BayesianFROC::dd


# Fit a model to data


    fit <- fit_Bayesian_FROC(  dataList = dd,
                                   ite  = 1111 )


# Extract a collection of expected hits as an array



    harray.expected  <-  extract_EAP_by_array(fit,ppp)*dd$NL



# Prepare hit (TP) data as an array


     harray <- array_of_hit_and_false_alarms_from_vector(dd)$harray




# Calculate the difference of hits and its expectation..



 Difference <- harray - harray.expected


# The above calculation is required in the chi square goodness of fit




#======================================================================================
#                           array format hit and false
#======================================================================================




   harray <- array_of_hit_and_false_alarms_from_vector(dataList = ddd)$harray
   farray <- array_of_hit_and_false_alarms_from_vector(dataList = ddd)$farray





}


}
\seealso{
\code{ \link{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}}
}
