% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{hits_rate_creator}
\alias{hits_rate_creator}
\title{MRMC Hit Rates Creator from Thresholds, Mean and S.D.}
\usage{
hits_rate_creator(z.truth = BayesianFROC::z_truth,
  mu.truth = BayesianFROC::mu_truth, v.truth = BayesianFROC::v_truth,
  is_hit_rate_adjusted = FALSE)
}
\arguments{
\item{z.truth}{Vector of dimension = C represents the thresholds of bi-normal assumption.}

\item{mu.truth}{array of dimension (M,Q). Mean of represents the signal distribution of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q). Standard Deviation of represents the signal distribution of bi-normal assumption.}

\item{is_hit_rate_adjusted}{whether the return value is
a vector of \deqn{p_c(\theta)} or  \deqn{hit rate_c :=  \frac{p_c(\theta)}{1- p_C(\theta)-p_{C-1}(\theta)-  ... - p_{c+1}(\theta)}  }.

The former is the default (FALSE) and the later is returned if \code{is_hit_rate_adjusted=TRUE}.}
}
\value{
A vector of the hit rate:

\deqn{hit rate_c :=  \frac{p_c(\theta)}{1- p_C(\theta)-p_{C-1}(\theta)-  ... - p_{c+1}(\theta)}  }







Do not confuse the old version \code{ppp} which is an array with three indices: \code{ppp[C,M,Q]}.
}
\description{
From thresholds, data of hit rate are created.

Note that the return values has changed from \eqn{p} (in \R notation:\code{ppp})
to

\deqn{hit rate_c :=  \frac{p_c(\theta)}{1- p_C(\theta)-p_{C-1}(\theta)-  ... - p_{c+1}(\theta)}  }
}
\examples{

\donttest{
#================The first example======================================

#     Using default values for hit rates, we can create a data of hits as follows:

        hits.rate <-hits_rate_creator()

#================The second example======================================

#     Using the hit rate from the hits_rate_creator(), we can get the hits data:

        hits_creator_from_rate(p.truth =hits_rate_creator() )

#================The remark for example======================================

# The author does not show how to specify the hit rates or threshods.
# For the details of it, please see the default values of such a quantities.


#================The 4-th example======================================

    p.truth.array <- hits_rate_creator()



#----------------------------------------------------------------------------------------
#2019 Sept 6
#----------------------------------------------------------------------------------------







}# dottest

}
