% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc.R
\name{Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc}
\alias{Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc}
\title{Simiulation Based Calibration (SBC) for single reader and single modality case}
\usage{

  Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(ww = -0.81,
  www = 0.001, mm = 0.65, mmm = 0.001, vv = 5.31, vvv = 0.001,
  zz = 1.55, zzz = 0.001, NL = 259, NI = 57, C = 3)
}
\arguments{
\item{ww}{A real number representing parameter of prior, indicating mean of prior for the first threshold}

\item{www}{A real number representing parameter of prior, variance of prior for the first threshold}

\item{mm}{A real number representing parameter of prior, mean of prior for the mean of signal distribution}

\item{mmm}{A real number representing parameter of prior, variance of prior for the variance of signal distribution}

\item{vv}{A real number representing parameter of prior,  mean of prior for the mean of signal distribution}

\item{vvv}{A real number representing parameter of prior, variance of prior for the variance of signal distribution}

\item{zz}{A real number representing parameter of prior, mean of prior for the  differences of thresholds}

\item{zzz}{A real number representing parameter of prior, variance of prior for the  differences of thresholds}

\item{NL}{number of lesions}

\item{NI}{numver of images}

\item{C}{number of confidence levels}
}
\value{
A list of S3 class "sbc", which is an outputs of  the \code{sbc} function in rstan.
}
\description{
Implements the SBC algorithm for the single reader and single modality case.
}
\details{
The implementation is done using the rstan::sbc. The stan file is \code{SBC.stan}
}
\examples{


#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------


#  Provides an Simulatiation Based Calibration for validation of our sampling.
#  We can confirmed that my model has very exact MCMC sampling.
#  SBC require suitable priors, and for the author, it seems very informative priors.
#  If we do not use the informative priors, then the odd data are generated from
#  the likelihood with the parameters drawn from priors. Such odd data has not fitted
#  our model, causing odd sampling.
#  If we do not choose the informative priors in suitable way, then it causes bias
#  in model. Even if the MCMC sampling is good in the sence of SBC, but the choise of
#  priors has no reasen, then it will cause bias. So, the author of this package
#  consider that  the bias of MCMC sampling and the bias of priors are trade off.
#  I write this program with no good nodition of health or not good environment,
#  not enogh money. So I write this with pain, pain in body, pain in life, pain in
#  money. So, this program let me be happy? I have to live. I must live.
#


# The default is three confidence levels,

\donttest{
#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------

fit<-Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
               ww=-0.81,www =0.001,
               mm=0.65,mmm=0.001,
               vv=5.31,vvv=0.001,
               zz= 1.55,zzz=0.001 )

#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------


# The following examle, we specify the variance of prior of first thresholds
# as 1 which is  very large for variance. If we take more large variance,
# then Stan cannot start sampling since its

# Run SBC algorithm
fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(www=1)


# Check uniformity intuitively
plot(fit,bins=10)# Not required since the above funtion also plot the rank statistics.

#----------------------------------------------------------------------------------------
#        Using default variables             SBC via rstan::sbc
#----------------------------------------------------------------------------------------

# Run SBC algorithm
fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc()


# Check uniformity intuitively

plot(fit,bins=10)

#----------------------------------------------------------------------------------------
#      Number of confidence level is 4        SBC via rstan::sbc
#----------------------------------------------------------------------------------------
# Run SBC algorithm
fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbcv(C=4)

# Check uniformity intuitively

plot(fit,bins=11)
}#donttest


}
\author{
Issei Tsunoda
}
