% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.BfMRI.sess.R
\name{is.a_session}
\alias{is.a_session}
\title{Validate an individual session in a \code{"BfMRI.sess"} object.}
\usage{
is.a_session(x)
}
\arguments{
\item{x}{The putative entry in a \code{"BfMRI.sess"} object.}
}
\value{
Logical. Is \code{x} a valid entry in a \code{"BfMRI.sess"} object?
}
\description{
Check if object is valid for a list entry in \code{"BfMRI.sess"}.
}
\details{
A valid entry in a \code{"BfMRI.sess"} object is a list with these named
fields:
\itemize{
\item{\code{"BOLD"}}{\eqn{T \times V} BOLD matrix. Rows are time points; columns are data locations (vertices/voxels).}
\item{\code{"design"}}{\eqn{T \times K} matrix containing the \eqn{K} task regressors. See \code{\link{make_HRFs}}.}
\item{\code{"nuisance"}}{Optional. \eqn{T \times J} matrix containing the \eqn{L} nuisance regressors.}
}
}
\keyword{internal}
