% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CumhazEval.R
\name{CumhazEval}
\alias{CumhazEval}
\title{Evaluate whether a true cumulative hazard function is contained
in the credible set.}
\usage{
CumhazEval(time.grid, true.cumhaz, post.mean, radius)
}
\arguments{
\item{time.grid}{The time grid on which to evaluate the cumulative
hazard.}

\item{true.cumhaz}{The true cumulative hazard function.}

\item{post.mean}{The posterior mean of the cumulative hazard, given
as a function.}

\item{radius}{The radius of the credible set for the cumulative hazard.}
}
\value{
\item{covered}{Indicator whether the true cumulative hazard function is
completely covered by the credible set on the times contained in
\code{time.grid}. 0 = not completely covered, 1 = completely covered.}
}
\description{
This function is intended to evaluate the Bayesian procedure in a
simulation study. To that end, this function can be used to check
whether the true (user-defined) cumulative hazard function is
contained in the credible set generated by the function
\link{BayesSurv}.
}
\examples{
#Demonstration on a simulated data set
library(simsurv)
library(ggplot2)
hazard.true <- function(t,x, betas, ...){1.2*(5*(t+0.05)^3 - 10*(t+0.05)^2 + 5*(t+0.05) ) + 0.7}
cumhaz.true <- Vectorize( function(t){integrate(hazard.true, 0, t)$value} )
sim.df <- data.frame(id = 1:1000)
df <- simsurv(x = sim.df, maxt = 1, hazard = hazard.true)

bs <- BayesSurv(df, "eventtime", "status")
K <- length(bs$haz.post.mean)
cumhaz.pm <- approxfun(c(0, (bs$time.max/K)*(1:K) ), c(0, cumsum(bs$haz.post.mean*bs$time.max/K)))
CumhazEval(bs$surv.eval.grid, cumhaz.true, cumhaz.pm, bs$cumhaz.radius)


}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv}, which computes the posterior mean of the
cumulative hazard as well as the radius for its credible set.
}
