% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpSphere-functions.R
\name{expcov_gpSphere}
\alias{expcov_gpSphere}
\title{Covariance kernel with squared-exponential for \code{gpSphere()}}
\usage{
expcov_gpSphere(vec, l, amp)
}
\arguments{
\item{vec}{Numeric vector of input locations. \eqn{t = X'\theta} is the main input value for the single-index model.}

\item{l}{Positive numeric scalar controlling the length-scale of the kernel.
Larger \code{l} yields slower decay of correlations.}

\item{amp}{Non-negative numeric scalar specifying the amplitude (variance scale)
of the kernel.}
}
\value{
A numeric \eqn{n \times n} covariance matrix with entries
\eqn{K_{ij} = \eta\,\exp\{-(t_i - t_j)^2 / l\}}
for \eqn{i, j = 1, \cdots, n}, symmetrized and stabilized with a
diagonal jitter term \eqn{10^{-4}}.
}
\description{
A \pkg{nimble} function that constructs a covariance matrix on
\eqn{t = X'\theta} using a squared–exponential Gaussian kernel with amplitude
\eqn{\eta} and length-scale parameter \eqn{l}.
Each entry is defined as \eqn{K_{ij} = \eta\exp\{-(t_i - t_j)^2 / l\}, \quad i, j = 1, \ldots, n},
symmetrized explicitly and stabilized with a small diagonal jitter term.
}
\details{
For the squared–exponential kernel construction, the covariance matrix is symmetrized
using \eqn{(K + K') / 2} and a small jitter term (\eqn{10^{-4}}) is added
to the diagonal to ensure positive-definiteness and numerical stability.
The parameters \code{amp} and \code{l} jointly control the amplitude
(vertical scale) and smoothness (horizontal scale) of the process.
}
\seealso{
\code{\link{gpSphere}}, \code{\link{predict.bsimGp}}
}
