% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFe.R
\name{BFe}
\alias{BFe}
\title{Equality of effect size Bayes factor}
\usage{
BFe(to, so, tr, sr, tau, log = FALSE)
}
\arguments{
\item{to}{Original effect estimate}

\item{so}{Standard error of the original effect estimate}

\item{tr}{Replication effect estimate}

\item{sr}{Standard error of the replication effect estimate}

\item{tau}{The heterogeneity standard deviation \eqn{\tau}{tau} under the
hypothesis of unequal effect sizes \eqn{H_1}{H1}}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}
}
\value{
The equality of effect size Bayes factor
\eqn{\mathrm{BF}_{01}}{BF01}. \eqn{\mathrm{BF}_{01} > 1}{BF01 > 1}
indicates that the data favour the hypothesis of equal effect sizes
\eqn{H_0}{H0} (replication success), whereas \eqn{\mathrm{BF}_{01} <
    1}{BF01 < 1} indicates that the data favour the hypothesis of unequal
effect sizes \eqn{H_1}{H1} (replication failure).
}
\description{
Computes the equality of effect size Bayes factor
}
\details{
The equality of effect size Bayes factor is the Bayes factor
contrasting the hypothesis of equal original and replication effect sizes
\eqn{H_0: \theta_o = \theta_r}{H0: theta_o = theta_r} to the hypothesis
of unequal effect sizes \eqn{H_1: \theta_o \neq \theta_r}{H1: theta_o !=
    theta_r}. Under the hypothesis of unequal effect sizes \eqn{H_1}{H1} the
study specific effect sizes are assumed to be normally distributed around
an overall effect size with heterogeneity standard deviation \code{tau}.
}
\examples{
## strong evidence for unequal effect sizes
BFe(to = 1, tr = 0.5, so = sqrt(1/100), sr = sqrt(1/100), tau = 0.3)

## some evidence for equal effect sizes
BFe(to = 1, tr = 1, so = sqrt(1/200), sr = sqrt(1/200), tau = 0.3)

 
}
\references{
Bayarri, M. and Mayorall, A. (2002). Bayesian Design of
"Successful" Replications. The American Statistician, 56(3): 207-214.
\doi{10.1198/000313002155}

Verhagen, J. and Wagenmakers, E. J. (2014). Bayesian tests to quantify the result
of a replication attempt. Journal of Experimental Psychology: General,
145:1457-1475. \doi{10.1037/a0036731}
}
\author{
Samuel Pawel
}
