% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_blc.R
\name{plot.BLC}
\alias{plot.BLC}
\title{Plot of BLC fitted models}
\usage{
\method{plot}{BLC}(x, parameter = "all", cred = 0.9, ages = NULL, ...)
}
\arguments{
\item{x}{A \code{BLC} or \code{PredBLC} object, result of a call to blc() function or forecast via predict() function.}

\item{parameter}{A character determines the parameter that will be plotted (\code{BLC} only). Default is "all" which means that all three parameters "alpha", "beta" and "kappa" will be plotted. It can also be "alpha", "beta", "kappa" or "fitted". The last one provides a plot with all the fitted tables.}

\item{cred}{A numeric value that indicates the probability for the credible interval. Default is '0.9'.}

\item{ages}{A numeric vector that represents the ages used in the fitted BLC model. Default is 'NULL'.}

\item{...}{Other arguments.}
}
\value{
A plot with the fitted log mortality or fitted values and credible intervals of the parameters.
}
\description{
This function plots the fitted log mortality values as well as the parameters values and credible intervals of the BLC fitted models.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, numit = 100, warmup = 20)

## Parameters' plot
plot(fit, parameter = "all")
\donttest{plot(fit, parameter = "beta", cred = 0.95)
plot(fit, parameter = "alpha", ages = 18:80)
plot(fit, parameter = "kappa")

## Fitted mortality graduation
plot(fit, parameter = "fitted", ages = 18:80)
}

}
\seealso{
\code{\link[=plot.HP]{plot.HP()}} and \code{\link[=plot.DLM]{plot.DLM()}} for \code{HP} or \code{DLM} methods.
}
