% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesMallows.R
\docType{package}
\name{BayesMallows-package}
\alias{BayesMallows-package}
\title{BayesMallows: Bayesian Preference Learning with the Mallows Rank Model}
\description{
An implementation of the Bayesian version of the Mallows rank model (Vitelli et al., Journal of Machine Learning Research, 2018 \url{https://jmlr.org/papers/v18/15-481.html}; Crispino et al., Annals of Applied Statistics, 2019 \doi{10.1214/18-AOAS1203}; Sorensen et al., R Journal, 2020 \doi{10.32614/RJ-2020-026}; Stein, PhD Thesis, 2023 \url{https://eprints.lancs.ac.uk/id/eprint/195759}). Both Metropolis-Hastings and sequential Monte Carlo algorithms for estimating the models are available. Cayley, footrule, Hamming, Kendall, Spearman, and Ulam distances are supported in the models. The rank data to be analyzed can be in the form of complete rankings, top-k rankings, partially missing rankings, as well as consistent and inconsistent pairwise preferences. Several functions for plotting and studying the posterior distributions of parameters are provided. The package also provides functions for estimating the partition function (normalizing constant) of the Mallows rank model, both with the importance sampling algorithm of Vitelli et al. and asymptotic approximation with the IPFP algorithm (Mukherjee, Annals of Statistics, 2016 \doi{10.1214/15-AOS1389}).
}
\references{
\insertRef{sorensen2020}{BayesMallows}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ocbe-uio/BayesMallows}
  \item \url{https://ocbe-uio.github.io/BayesMallows/}
  \item Report bugs at \url{https://github.com/ocbe-uio/BayesMallows/issues}
}

}
\author{
\strong{Maintainer}: Oystein Sorensen \email{oystein.sorensen.1985@gmail.com} (\href{https://orcid.org/0000-0003-0724-3542}{ORCID})

Authors:
\itemize{
  \item Waldir Leoncio \email{w.l.netto@medisin.uio.no}
  \item Valeria Vitelli \email{valeria.vitelli@medisin.uio.no} (\href{https://orcid.org/0000-0002-6746-0453}{ORCID})
  \item Marta Crispino \email{crispino.marta8@gmail.com}
  \item Qinghua Liu \email{qinghual@math.uio.no}
  \item Cristina Mollica \email{cristina.mollica@uniroma1.it}
  \item Luca Tardella
  \item Anja Stein
}

}
\keyword{internal}
