% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_func.R
\name{SMNGdistribution}
\alias{SMNGdistribution}
\alias{dSMNG}
\alias{pSMNG}
\alias{qSMNG}
\alias{rSMNG}
\alias{dlSMNG}
\alias{plSMNG}
\alias{qlSMNG}
\alias{rlSMNG}
\title{SMNG and logSMNG Distributions}
\usage{
dSMNG(
  x,
  mu = 0,
  delta,
  gamma,
  lambda,
  beta = 0,
  inf_sum = FALSE,
  rel_tol = 1e-05
)

pSMNG(q, mu, delta, gamma, lambda, beta, rel_tol = 1e-05)

qSMNG(p, mu, delta, gamma, lambda, beta, rel_tol = 1e-05)

rSMNG(n, mu, delta, gamma, lambda, beta)

dlSMNG(x, mu = 0, delta, gamma, lambda, beta, inf_sum = FALSE, rel_tol = 1e-05)

plSMNG(q, mu, delta, gamma, lambda, beta, rel_tol = 1e-05)

qlSMNG(p, mu, delta, gamma, lambda, beta, rel_tol = 1e-05)

rlSMNG(n, mu, delta, gamma, lambda, beta)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Location parameter, default set to 0.}

\item{delta}{Concentration parameter, must be positive.}

\item{gamma}{Tail parameter, must be positive.}

\item{lambda}{Shape parameter.}

\item{beta}{Skewness parameter, default set to 0 (symmetric case).}

\item{inf_sum}{Logical: if FALSE (default) the integral representation of the SMNG density is used,
otherwise the infinite sum is employed.}

\item{rel_tol}{Level of relative tolerance required for the \code{integrate} procedure or for the infinite sum convergence check.
Default set to \code{1e-5}.}

\item{p}{Vector of probabilities.}

\item{n}{Sample size.}
}
\value{
\code{dSMNG} and \code{dlSMNG} provide the values of the density function at a quantile \code{x} for, respectively
 a SMNG distribution and a log-SMNG.

\code{pSMNG} and \code{plSMNG} provide the cumulative distribution function at a quantile \code{q}.

\code{qSMNG} and \code{qlSMNG} provide the quantile corresponding to a probability level \code{p}.

\code{rSMNG} and \code{rlSMNG} generate \code{n} independent samples from the desired distribution.
}
\description{
Density function, distribution function, quantile function and random generator for the SMNG distribution and the logSMNG.
It requires the specification of a five prameters vector: \code{mu}, \code{delta}, \code{gamma}, \code{lambda} and
\code{beta}.
}
\details{
The SMNG distribution is a normal scale-mean mixture distribution with a GIG as mixing distribution. The
density can be expressed as an infinite sum of Bessel K functions and it is characterized by 5 parameters.

Moreover, if X is SMNG distributed, then \eqn{Z=exp(X)} is distributed as a log-SMNG distribution.
}
\examples{
\donttest{
### Plots of density and cumulative functions of the SMNG distribution
x<-seq(-10,10,length.out = 500)

plot(x,dSMNG(x = x,mu = 0,delta = 1,gamma = 1,lambda = 1,beta= 2),
    type="l",ylab="f(x)")
lines(x,dSMNG(x = x,mu = 0,delta = 1,gamma = 1,lambda = 1,beta= -2),col=2)
title("SMNG density function")

plot(x,pSMNG(q = x,mu = 0,delta = 1,gamma = 1,lambda = 1,beta= 2),
    type="l",ylab="F(x)")
lines(x,pSMNG(q = x,mu = 0,delta = 1,gamma = 1,lambda = 1,beta= -2),col=2)
title("SMNG cumulative function")


### Plots of density and cumulative functions of the logSMNG distribution
x<-seq(0,20,length.out = 500)

plot(x,dlSMNG(x = x,mu = 0,delta = 1,gamma = 1,lambda = 2,beta = 1),
    type="l",ylab="f(x)",ylim = c(0,1.5))
lines(x,dlSMNG(x = x,mu = 0,delta = 1,gamma = 1,lambda = 2,beta = -1),col=2)
title("logSMNG density function")

plot(x,plSMNG(q = x,mu = 0,delta = 1,gamma = 1,lambda = 2,beta = 1),
    type="l",ylab="F(x)",ylim = c(0,1))
lines(x,plSMNG(q = x,mu = 0,delta = 1,gamma = 1,lambda = 2,beta = -1),col=2)
title("logSMNG cumulative function")
}

}
