% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_func.R
\name{SMNGmoments}
\alias{SMNGmoments}
\alias{SMNG_MGF}
\alias{meanSMNG}
\alias{SMNGmoment}
\title{SMNG Moments and Moment Generating Function}
\usage{
SMNG_MGF(
  r,
  mu = 0,
  delta,
  gamma,
  lambda,
  beta = 0,
  inf_sum = FALSE,
  rel_tol = 1e-05
)

meanSMNG(mu, delta, gamma, lambda, beta)

SMNGmoment(j, mu, delta, gamma, lambda, beta, type = "central")
}
\arguments{
\item{r}{Coefficient of the MGF. Can be viewed also as the order of the logSMNG moments.}

\item{mu}{Location parameter, default set to 0.}

\item{delta}{Concentration parameter, must be positive.}

\item{gamma}{Tail parameter, must be positive.}

\item{lambda}{Shape parameter.}

\item{beta}{Skewness parameter, default set to 0 (symmetric case).}

\item{inf_sum}{Logical: if FALSE (default), the integral representation of the SMNG density is used,
otherwise the infinite sum is employed.}

\item{rel_tol}{Level of relative tolerance required for the \code{integrate} procedure or for the infinite sum.
Default set to \code{1e-5}.}

\item{j}{Order of the moment.}

\item{type}{String that indicate the kind of moment to comupute. Could be \code{"central"} (default) or \code{"raw"}.}
}
\description{
Functions that implement the mean, the generic moments (both raw and centered) and the moment generating function of the SMNG distribution.
}
\details{
If the mean (i.e. the first order raw moment) of the SMNG distribution is required, then the function \code{meanSMNG} could be use.

On the other hand, to obtain the generic \emph{j}-th moment both \code{"raw"} or \code{"centered"} around the mean, the function \code{momentSMNG} could be used.

Finally, to evaluate the Moment Generating Function (MGF) of the SMNG distribution in the point \code{r}, the function \code{SMNG_MGF} is provided.
It is defined only for points that are lower then the parameter \code{gamma}, and for integer values of \code{r} it could also considered as the
\emph{r}-th raw moment of the logSMNG distribution. The last function is implemented both in the integral form, which uses the routine \code{\link{integrate}},
or in the infinite sum structure.
}
\examples{

### Comparisons sample quantities vs true values
sample <- rSMNG(n=50000,mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2)
mean(sample)
meanSMNG(mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2)

var(sample)
SMNGmoment(j = 2,mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2,type = "central")
SMNGmoment(j = 2,mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2,type = "raw")-
                        meanSMNG(mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2)^2

mean(exp(sample))
SMNG_MGF(r = 1,mu = 0,delta = 2,gamma = 2,lambda = 1,beta = 2)


}
