% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{.plot_matrix}
\alias{.plot_matrix}
\title{Plot smoothed baseline hazards}
\usage{
.plot_matrix(
  x_lim,
  y,
  percentiles = c(0.05, 0.95),
  title = "",
  xlab = "",
  ylab = "",
  color = "blue",
  fill = "blue",
  linewidth = 1,
  alpha = 0.2,
  y2 = NULL,
  color2 = "red",
  fill2 = "red"
)
}
\arguments{
\item{x_lim}{time grid}

\item{y}{samples}

\item{percentiles}{percentiles to include in plot, default is c(0.025, 0.975)}

\item{title}{optional, add title to plot}

\item{xlab}{optional, add xlabel}

\item{ylab}{optional, add ylabel}

\item{color}{color of the mid line, default is blue}

\item{fill}{color of the percentiles, default is blue}

\item{linewidth}{thickness of the plotted line, default is 1}

\item{alpha}{opacity of the percentiles, default is 0.2}

\item{y2}{(optional) second set of samples for comparison}

\item{color2}{(optional) color of the mid line, default is red}

\item{fill2}{(optional) color of the percentiles, default is red}
}
\value{
a ggplot2 object
}
\description{
Plot mean and given quantiles of a matrix. Can also be used to 
plot derivatives of the baseline hazard, such as estimated cumulative hazard 
and survival function.
}
