% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{coef.BayesFBHborrow}
\alias{coef.BayesFBHborrow}
\title{Extract mean posterior values}
\usage{
\method{coef}{BayesFBHborrow}(object, ...)
}
\arguments{
\item{object}{MCMC sample object from BayesFBHborrow()}

\item{...}{other arguments, see coef.default()}
}
\value{
mean values of given samples
}
\description{
S3 method for class "BayesFBHborrow", returns the mean posterior values
for the fixed parameters
}
\examples{
data(piecewise_exp_cc, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(piecewise_exp_cc$tte, c(0.5, 1.0), names = FALSE))
initial_param <- list("J" = 1, 
                      "s_r" = s[2], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = c(1, 1), 
                       "beta" = 0)
               
# run the MCMC sampler CHANGE THIS BEFORE FINAL CHECK
out <- BayesFBHborrow(piecewise_exp_cc, NULL, initial_param,
                iter = 10, warmup_iter = 1)

# Plot the posterior mean values of the fixed parameters
coef(out)
}
