% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_ermod.R
\name{eval_ermod}
\alias{eval_ermod}
\title{Evaluate exposure-response model prediction performance}
\usage{
eval_ermod(
  ermod,
  eval_type = c("training", "kfold", "test"),
  newdata = NULL,
  summary_method = c("median", "mean"),
  k = 5,
  seed_kfold = NULL
)
}
\arguments{
\item{ermod}{An object of class \code{ermod}.}

\item{eval_type}{A character string specifying the evaluation dataset.
Options are:
\itemize{
\item \code{training}: Use the training dataset.
\item \code{test}: Use a new dataset for evaluation.
\item \code{kfold}: Perform k-fold cross-validation (uses \code{newdata} if provided,
otherwise uses the training dataset).
}}

\item{newdata}{A data frame containing new data for evaluation when
\code{eval_type} is set to \code{test} or \code{kfold}.}

\item{summary_method}{A character string specifying how to summarize the
simulation draws. Default is \code{median}.}

\item{k}{The number of folds for cross-validation. Default is 5.}

\item{seed_kfold}{Random seed for k-fold cross-validation.}
}
\value{
A tibble with calculated performance metrics, such as AUROC or
RMSE, depending on the model type.
}
\description{
This function evaluates the performance of an exposure-response model
using various metrics.
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)
d_split <- rsample::initial_split(d_sim_binom_cov_hgly2)
d_train <- rsample::training(d_split)
d_test <- rsample::testing(d_split)

ermod_bin <- dev_ermod_bin(
  data = d_train,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
  # Settings to make the example run faster
  chains = 2,
  iter = 1000
)

metrics_training <- eval_ermod(ermod_bin, eval_type = "training")
metrics_test <- eval_ermod(ermod_bin, eval_type = "test", newdata = d_test)
metrics_kfold <- eval_ermod(ermod_bin, eval_type = "kfold", k = 3)

print(metrics_training)
print(metrics_test)
print(metrics_kfold)
}

}
