% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_ermod_lin.R
\name{dev_ermod_bin}
\alias{dev_ermod_bin}
\alias{dev_ermod_lin}
\title{Develop linear ER model for binary or continuous endpoint}
\usage{
dev_ermod_bin(
  data,
  var_resp,
  var_exposure,
  var_cov = NULL,
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)

dev_ermod_lin(
  data,
  var_resp,
  var_exposure,
  var_cov = NULL,
  verbosity_level = 1,
  chains = 4,
  iter = 2000
)
}
\arguments{
\item{data}{Input data for E-R analysis}

\item{var_resp}{Response variable name in character}

\item{var_exposure}{Exposure variable names in character}

\item{var_cov}{Covariate variable names in character vector}

\item{verbosity_level}{Verbosity level. 0: No output, 1: Display steps,
2: Display progress in each step, 3: Display MCMC sampling.}

\item{chains}{Number of chains for Stan.}

\item{iter}{Number of iterations for Stan.}
}
\value{
An object of class \code{ermod_bin} or \code{ermod_lin}.
}
\description{
These functions are used to develop an linear ER model with binary
(\code{\link[=dev_ermod_bin]{dev_ermod_bin()}}) or continuous (\code{\link[=dev_ermod_lin]{dev_ermod_lin()}}) endpoint.
You can also specify covariates to be included in the model.
}
\examples{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

ermod_bin

data(d_sim_lin)

ermod_lin <- dev_ermod_lin(
  data = d_sim_lin,
  var_resp = "response",
  var_exposure = "AUCss",
  var_cov = c("SEX", "BAGE")
)

ermod_lin

}
