% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeibullCode.R
\name{genweibulldata}
\alias{genweibulldata}
\title{Generating function for Weibull Data.}
\usage{
genweibulldata(sample_size, scale1, hazard_ratio, common_shape,
  censor_value)
}
\arguments{
\item{sample_size}{Number of subjects per arm.}

\item{scale1}{Scale parameter used in call to \code{rweibull()}.
Used only in control arm.}

\item{hazard_ratio}{Desired Hazard Ratio between experimental and control groups.}

\item{common_shape}{Shape parameter used in call to \code{rweibull()}.
Used in both arms.}

\item{censor_value}{Value at which time-to-event data are right censored.}
}
\value{
\code{genweibulldata()} returns a data frame with columns: 'id', 'treatment',
  'event_time', and 'status'.
}
\description{
\code{genweibulldata()} function used mainly internally by
\code{weibulltrialsimulator()} and \code{weibulltrialsimulatornohist()} functions
 to generate data for a two-arm clinical trial, experimental and control groups.
 Can be used to generate random trial data.
}
\examples{
SampleHistData <- genweibulldata(sample_size=60, scale1=2.82487,
                                 hazard_ratio=0.6, common_shape=3,
                                 censor_value=3)
SampleHistData
}
