% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt.forest.R
\name{plt.forest}
\alias{plt.forest}
\title{this plot function makes a forest plot.}
\usage{
plt.forest(data, obj, ...)
}
\arguments{
\item{data}{an input dataset with the same structure as the example data \code{epidural_c}, 
containing multiple rows referring to multiple studies in a meta-analysis.}

\item{obj}{a model object returned by \code{cace.meta.c}, \code{cace.meta.ic},
or \code{cace.study}}

\item{...}{optional parameters passed into the \code{forestplot} function from the
\code{forestplot} library}
}
\value{
It returns a forestplot object in an \code{R} plot window.
}
\description{
This function provides a visual overview (forest plot) for a model object and corresponding dataset.
}
\examples{
\donttest{
data("epidural_c", package = "BayesCACE")
out.meta.c <- cace.meta.c(data = epidural_c, conv.diag = TRUE, 
mcmc.samples = TRUE, study.specific = TRUE)
plt.forest(data=epidural_c, obj=out.meta.c)
}
}
