% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt.cacebayes.R
\name{plt.density}
\alias{plt.density}
\title{this plot function creates a density plot}
\usage{
plt.density(obj, param = c("CACE"), trialnumber = 1, ...)
}
\arguments{
\item{obj}{a \code{cace.Bayes} object, returned by \code{cace.meta.c}, \code{cace.meta.ic},
or \code{cace.study}}

\item{param}{list of parameters to plot}

\item{trialnumber}{indicator for which trial number of the mcmc samples
to use. The default is \code{1}}

\item{...}{optional parameters to pass into the \code{plot} function}
}
\value{
It returns a density plot in an \code{R} plot window.
}
\description{
This function creates a density plot for a \code{cace.Bayes} object.
}
\examples{
\donttest{
out.meta.c <- cace.meta.c(data = epidural_c, conv.diag = TRUE, 
mcmc.samples = TRUE, study.specific = TRUE)
plt.density(obj=out.meta.c)
}
}
