% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Age_Computation.R
\name{Age_Computation}
\alias{Age_Computation}
\title{Bayesian analysis for the OSL age estimation of one sample}
\usage{
Age_Computation(DATA, SampleName, PriorAge = c(0.01, 100),
  BinPerSample = c(1), SavePdf = FALSE,
  OutputFileName = c("MCMCplot"), OutputFilePath = c(""),
  SaveEstimates = FALSE, OutputTableName = c("DATA"),
  OutputTablePath = c(""), LIN_fit = TRUE, Origin_fit = FALSE,
  distribution = c("cauchy"), I = 1, Iter = 50000, t = 5,
  n.chains = 3, quiet = FALSE)
}
\arguments{
\item{DATA}{\link{list} of objects: \code{LT}, \code{sLT}, \code{ITimes}, \code{dLab}, \code{ddot_env}, \code{regDose}, \code{J}, \code{K}, \code{Nb_measurement},
provided by the function \link{Generate_DataFile} or \link{Generate_DataFile_MG}.

\code{DATA} can contain information for more than one sample.}

\item{SampleName}{\link{character}: name of the sample.}

\item{PriorAge}{\link{numeric} (with default): lower and upper bounds for the sample age parameter (in ka).
Note that, \code{length(PriorAge)=2}.}

\item{BinPerSample}{\link{integer} (with default): vector with the number of BIN files per sample.
If in \code{DATA} there is more than one sample,
the \code{BinPerSample} vector must be the same as that used to run the function
\link{Generate_DataFile} or in \link{Generate_DataFile_MG} for generating the \code{DATA} object.}

\item{SavePdf}{\link{logical} (with default): if TRUE save graph in pdf file named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputFileName}{\link{character} (with default): name of the pdf file that will be generated by the function if \code{SavePdf = TRUE};
\code{length(OutputFileName = 2}, see \strong{PLOT OUTPUT} in \strong{Value} section for more informations.}

\item{OutputFilePath}{\link{character} (with default): path to the pdf file that will be generated by the function if \code{SavePdf = TRUE}.
If it is not equal to "", it must be terminated by "/".}

\item{SaveEstimates}{\link{logical} (with default): if TRUE save Bayes estimates and credible interval at level 68\% and 95\%  and
the result of the gelman en Rubin test of convergency, in a csv table named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputTableName}{\link{character} (with default): name of the table that will be generated by the function if \code{SaveEstimates = TRUE}.}

\item{OutputTablePath}{\link{character} (with default): path to the table that will be generated by the function if  \code{SaveEstimates = TRUE}.
If it is not equal to "", it must be terminated by "/".}

\item{LIN_fit}{\link{logical} (with default): if \code{TRUE} (default) allows a linear component,
on top of the (default) saturating exponential curve, for the fitting of dose response curves.
See details section for more informations on the proposed dose response curves.}

\item{Origin_fit}{\link{logical} (with default): if \code{TRUE}, forces the dose response curves to pass through the origin.
See details section for more informations on the proposed growth curves.}

\item{distribution}{\link{character} (with default): type of distribution that defines
how individual equivalent dose values are distributed around the palaeodose.
Allowed inputs are \code{"cauchy"}, \code{"gaussian"}, \code{"lognormal_A"} and \code{"lognormal_M"}, see details section for more informations.}

\item{I}{\link{integer} (with default): if \code{DATA} contains data from more than one sample,
I indicates the ID number of the sample to be analysed.}

\item{Iter}{\link{integer} (with default): number of iterations for the MCMC computation (for more information see \link{jags.model}).}

\item{t}{\link{integer} (with default): 1 every \code{t} iterations of the MCMC is considered for sampling the posterior distribution
(for more information see \link{jags.model}).}

\item{n.chains}{\link{integer} (with default): number of independent chains for the model (for more information see \link{jags.model}).}

\item{quiet}{\link{logical} (with default): enables/disables \link{rjags} messages}
}
\value{
\strong{NUMERICAL OUTPUT}

\enumerate{
\item \strong{A list containing the following objects}:
\itemize{
\item \strong{Sampling} that corresponds to a sample of the posterior distributions
of the age (in ka), palaeodose (in Gy) and equivalent dose dispersion (in Gy) parameters.
\item \strong{Model_GrowthCurve}, stating which dose response fitting option was chosen;
\item \strong{Distribution}, stating which distribution was chosen to model the dispersion of
individual equivalent dose values around the palaeodose of the sample;
\item \strong{PriorAge}, stating the priors used for the age parameter (in ka).
}
\item \strong{The Gelman and Rubin test of convergency}: prints the result of the Gelman and Rubin test of convergency for the age, palaeodose and equivalent dose dispersion parameters.
A result close to one is expected.\cr
In addition, the user must visually assess the convergency of the trajectories by looking at the graph
generated by the function (see \strong{PLOT OUTPUT} for more informations).\cr
If both convergencies (Gelman and Rubin test and plot checking) are satisfactory,
the user can consider the printed estimates as valid. Otherwise, the user may try increasing the number of MCMC interations
(\code{Iter}), or being more precise on the \code{PriorAge} parameter (for example specify if it is a young sample \code{c(0.01,10)} an old sample \code{c(10,100)}),
or changing the parameter \code{distribution} or the growth curve, to reach convergency.to reach convergency.
\item \strong{Credible intervals and Bayes estimates}: prints the Bayes esitmates, the credible intervals at 95\% and 68\% for
the age, palaeodose and equivalent dose dispersion parameters of the sample.
}

\strong{PLOT OUTPUT}

A graph with the MCMC trajectories and posterior distributions of the age, palaeodose and equivalent dose dispersion parameters is displayed.\cr
The first line of the figure correponds to the age parameter, the second to the palaeodose parameter and the third to the equivalent dose dispersion parameter.
On each line, the plot on the left represents the MCMC trajectories, and the one on the right the posterior distribution of the parameter.

To give the results in a publication, we recommend to give the Bayes estimate of the parameter as well as the credible interval at 95\% or 68\%.
}
\description{
This function computes the age (in ka) of a sample according to the model developed in Combes and Philippe (2017),
based on an output of \link{Generate_DataFile} or \link{Generate_DataFile_MG}.\cr
A sample, for which data is avalilable in several BIN files, can be analysed.
}
\details{
\strong{Option on growth curves}\cr

As for \link{AgeS_Computation} and \link{Palaeodose_Computation}, the user can choose from 4 dose response curves:
\itemize{
\item \strong{Saturating exponential plus linear growth} (\code{AgeMultiBF_EXPLIN}):

for all \code{x} in IR+, \eqn{f(x)=a(1-exp(-x/b))+cx+d}; select
\itemize{
\item \code{LIN_fit=TRUE}
\item \code{Origin_fit=FALSE}
}
\item \strong{Saturating exponential growth} (\code{AgeMultiBF_EXP}):

for all \code{x} in IR+, \eqn{f(x)=a(1-exp(-x/b))+d}; select
\itemize{
\item \code{LIN_fit = FALSE}
\item \code{Origin_fit = FALSE}
}
\item \strong{Saturating exponential plus linear growth and fitting through the origin} (\code{AgeMultiBF_EXPLINZO}):

for all \code{x} in IR+, \eqn{f(x)=a(1-exp(-x/b))+cx}; select
\itemize{
\item \code{LIN_fit=TRUE}
\item \code{Origin_fit=TRUE}
}
\item \strong{Saturating exponential growth and fitting through the origin} (\code{AgeMultiBF_EXPZO}):

for all \code{x} in IR+, \eqn{f(x)=a(1-exp(-x/b))}; select
\itemize{
\item \code{LIN_fit=FALSE}
\item \code{Origin_fit=TRUE}
}
}

\strong{Option on equivalent dose distribution around the palaeodose}\cr

The use can choose between :
\itemize{
\item \code{cauchy}: a Cauchy distribution with location parameter equal to the palaeodose of the sample
\item \code{gaussian}: a Gaussian distribution with mean equal to the palaeodose of the sample
\item \code{lognormal_A}: a log-normal distribution with mean or \strong{A}verage equal to the palaeodose of the sample
\item \code{lognormal_M}: a log-normal distribution with \strong{M}edian equal to the palaeodose of the sample
}
}
\note{
Please note that the initial values for all MCMC are currently all the same for all chains since we rely on the automatic
initial value generation of JAGS. This is not optimal and will be changed in future. However, it does not affect the quality
of the age estimates if the chains have converged.
}
\examples{
## load data file generated by the function Generate_DataFile
data(DATA1,envir = environment())
priorage <- c(10,60) # GDB3 is an old sample
Age <- Age_Computation(
 DATA = DATA1,
 SampleName = "GDB3",
 PriorAge = priorage,
 Iter = 100,
 quiet = TRUE)

}
\references{
Combes, Benoit and Philippe, Anne, 2017.
Bayesian analysis of multiplicative Gaussian error for multiple ages estimation in optically
stimulated luminescence dating.
Quaternary Geochronology (39, 24-34)

Combes, B., Philippe, A., Lanos, P., Mercier, N., Tribolo, C., Guerin, G., Guibert, P., Lahaye, C., 2015.
A Bayesian central equivalent dose model for optically stimulated luminescence dating.
Quaternary Geochronology 28, 62-70. doi:10.1016/j.quageo.2015.04.001
}
\seealso{
\link{Generate_DataFile}, \link{Generate_DataFile_MG}, \link{rjags}, \link{plot_MCMC}, \link{AgeS_Computation}, \link{Palaeodose_Computation}
}
\author{
Claire Christophe, Sebastian Kreutzer, Anne Philippe, Guillaume Guérin
}
