% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustering.R
\name{hclustering}
\alias{hclustering}
\title{Agglomerative hierarchical clustering}
\usage{
hclustering(data, k = NULL, nclumax = 10, labels = NULL, linkage = "ward.D")
}
\arguments{
\item{data}{numeric data frame.}

\item{k}{integer, number of clusters.}

\item{nclumax}{integer, maximum number of clusters (when \code{k=NULL}).}

\item{labels}{character, row labels.}

\item{linkage}{character, the agglomeration method to be used in \code{hclust} (see \code{method} in \link[stats]{hclust}).}
}
\value{
A \code{hclustering} object.

If \code{k} is \code{NULL}, the \code{hclustering} object is a list of 3 elements:

\itemize{
\item \code{k} \code{NULL}
}

\itemize{
\item \code{clusterRange} integer vector, values of \code{k} (from 1 to \code{nclumax}) at which the \emph{variance between} of the clusterization is evaluated
}

\itemize{
\item \code{VarianceBetween} numeric vector, values of the \emph{variance between} evaluated for \code{k} in \code{clusterRange}
}

If \code{k} is not \code{NULL}, the \code{hclustering} object is a list of 5 elements:

\itemize{
\item \code{k} integer, number of clusters
}

\itemize{
\item \code{Subjects} data frame, subjects' cluster identifiers
}

\itemize{
\item \code{ClusterList} list, clusters' composition
}

\itemize{
\item \code{Profiles} data frame, clusters' profiles, i.e. the average of the variables within clusters and the cluster eterogeineity index (\code{CHI})
}

\itemize{
\item \code{Hclust} an object of class \code{hclust}, see \code{\link[stats]{hclust}}
}
}
\description{
Agglomerative hierarchical clustering
}
\details{
The \code{hclustering} function performs a preliminary standardization of columns in \code{data}.
}
\examples{
data <- with(Pbox, data.frame(PTS, P3M, REB=OREB+DREB, AST, TOV, STL, BLK, PF))
data <- subset(data, Pbox$MIN >= 1500)
ID <- Pbox$Player[Pbox$MIN >= 1500]
hclu1 <- hclustering(data)
plot(hclu1)
hclu2 <- hclustering(data, labels=ID, k=7)
plot(hclu2)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{plot.hclustering}}, \code{\link[stats]{hclust}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
