% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/add_relation.R
\name{add_relation}
\alias{add_relation}
\alias{add_relation,TidySet,data.frame-method}
\title{Add relations}
\usage{
add_relation(object, relations, ...)

\S4method{add_relation}{TidySet,data.frame}(object, relations)
}
\arguments{
\item{object}{A TidySet object}

\item{relations}{A data.frame object}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}
}
\value{
A \code{TidySet} object.
}
\description{
Given a TidySet adds new relations between elements and sets.
}
\section{Methods (by class)}{
\itemize{
\item \code{add_relation(object = TidySet, relations = data.frame)}: Adds relations

}}
\examples{
relations <- data.frame(
    sets = c(rep("A", 5), "B"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
relations <- data.frame(
    sets = c(rep("A2", 5), "B2"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6),
    new = runif(6)
)
add_relation(TS, relations)
}
\seealso{
Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{add functions}
\concept{methods}
