% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare2delimitations.R
\name{compare2delimitations}
\alias{compare2delimitations}
\title{Comparision between two Delimitations}
\usage{
compare2delimitations(deli1, deli2)
}
\arguments{
\item{deli1}{a character array (vector),containing a set of, for example, morphological identification (species names), to compare with}

\item{deli2}{a character array (vector),containing a set of, molecular delimitation (MOTU).}
}
\value{
a list containing the adjusted Rand index comparing the two partitions (a scalar). This index has zero expected value in the case
 of random partition, and it is bounded above by 1 in the case of perfect agreement between two partitions; the numbers of matches,
 splits,merges, and corresponding percentage.
}
\description{
Comparision between two delimitations of a group of samples, for instance,
traditionally morphological delimitation and molecular delimitation (MOTU).
}
\note{
This is for the same set of samples with two partitions/delimitations.
}
\examples{





deli1<-c(1,1,1,1,1,1)
deli2<-c(1,1,2,1,1,3)
out<-compare2delimitations(deli1,deli2)
out
}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA.
}
\references{
L. Hubert and P. Arabie (1985) Comparing Partitions, Journal of the Classification 2:193-218.
}
\keyword{compare2delimitations}

