% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{Regression-class}
\alias{Regression-class}
\title{S4 class of model informations for the regression model}
\description{
Informations of model
  \eqn{y_i = f(\phi, t_i) + \epsilon_i, \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t_i))}.
}
\section{Slots}{

\describe{
\item{\code{phi}}{parameter \eqn{\phi}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{fun}}{function \eqn{f(\phi, t)}}

\item{\code{sT.fun}}{function \eqn{\widetilde{s}(t)}}

\item{\code{prior}}{list of prior parameters}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(phi = c(3, 1), gamma2 = 0.1)
fun <- function(phi, t) phi[1] + phi[2]*t
sT.fun <- function(t) t
prior <- list(m.phi = parameter$phi, v.phi = parameter$phi^2,
   alpha.gamma = 3, beta.gamma = 2*parameter$gamma2)
start <- parameter
model <- set.to.class("Regression", parameter, prior, start, fun = fun, sT.fun = sT.fun)
}

