% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/54_predict.R, R/55_fcast_print.R
\name{predict.bvar}
\alias{predict.bvar}
\alias{predict<-}
\alias{summary.bvar_fcast}
\title{Predict method for Bayesian VARs}
\usage{
\method{predict}{bvar}(object, ..., conf_bands, n_thin = 1L, newdata)

predict(object) <- value

\method{summary}{bvar_fcast}(object, vars = NULL, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.
Summary and print methods take in a \code{bvar_fcast} object.}

\item{...}{A \code{bv_fcast} object or parameters to be fed into
\code{\link{bv_fcast}}. Contains settings for the forecast.}

\item{conf_bands}{Numeric vector of confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. 0.5 is always included.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th draw in \emph{object}
is used to predict, others are dropped.}

\item{newdata}{Optional numeric matrix or dataframe. Used to base the
prediction on.}

\item{value}{A \code{bvar_fcast} object to assign.}

\item{vars}{Optional numeric or character vector. Used to subset the summary
to certain variables by position or name (must be available). Defaults to
\code{NULL}, i.e. all variables.}
}
\value{
Returns a list of class \code{bvar_fcast} including forecasts
at desired confidence bands.
The summary method returns a numeric array of forecast paths at the
specified confidence bands.
}
\description{
Retrieves / calculates forecasts for Bayesian VARs generated via
\code{\link{bvar}}. If a forecast is already present and no settings are
supplied it is simply retrieved, otherwise it will be calculated.
To store the results you may want to assign the output using the setter
function (\code{predict(x) <- predict(x)}). May also be used to update
confidence bands.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Calculate a forecast with an increased horizon
y <- predict(x, horizon = 20)

# Add some confidence bands and store the forecast
predict(x) <- predict(x, conf_bands = c(0.05, 0.16))

# Recalculate with different settings and increased thinning
predict(x, bv_fcast(24L), n_thin = 10L)

# Simulate some new data to predict on
predict(x, newdata = matrix(rnorm(300), ncol = 3))

# Calculate a conditional forecast (with a constrained second variable).
predict(x, cond_path = c(1, 1, 1, 1, 1, 1), cond_var = 2)

# Get a summary of the stored forecast
summary(x)

# Only get the summary for variable #2
summary(x, vars = 2L)
}
}
\seealso{
\code{\link{plot.bvar_fcast}}; \code{\link{bv_fcast}}
}
\keyword{BVAR}
\keyword{analysis}
\keyword{forecast}
