% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/68_irf_plot.R, R/deprecated.R
\name{plot.bvar_irf}
\alias{plot.bvar_irf}
\alias{bv_plot_irf}
\title{Plotting method for Bayesian VAR impulse responses}
\usage{
\method{plot}{bvar_irf}(x, conf_bands, vars_response = NULL,
  vars_impulse = NULL, variables = NULL, mar = c(2, 2, 2, 0.5), ...)

bv_plot_irf(x, conf_bands = 0.16, variables = NULL,
  vars_impulse = NULL, vars_response = NULL, mar = c(2, 2, 2, 0.5),
  ...)
}
\arguments{
\item{x}{A \code{bvar} / \code{bvar_irf} object, obtained from
\code{\link{bvar}} / \code{\link{irf.bvar}}.}

\item{conf_bands}{Deprecated. Use \code{\link{irf.bvar}}. Numeric vector
of desired confidence bands.}

\item{vars_impulse, vars_response}{Optional numeric or character vector. Used
to subset the plot's impulses / responses to certain variables by position
or name (must be available). Defaults to \code{NULL}, i.e. all variables.}

\item{variables}{Optional character vector. Names of all variables in the
object. Used to subset and title. Taken from \code{x$variables} if available.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Plotting method for impulse responses obtained from \code{\link{bvar}} or
\code{\link{irf.bvar}}. Impulse responses of all or a subset of the
available variables can be plotted.
}
\examples{
\donttest{
data <- matrix(rnorm(400), ncol = 4)
x <- bvar(data, lags = 2, irf = bv_irf())

# Plot impulse responses for all available variables
plot(irf(x))
# Alternatively
plot(x$irf)

# Subset to impulse variables in positions 2 and 4 via position and name
plot(x$irf, vars_impulse = c(2, 4))
plot(x$irf,
  variables = c("solved", "for", "many", "decades"),
  vars_impulse = c("for", "decades")
)

# Adjust confidence bands via irf
plot(irf(x, conf_bands = c(0.01, 0.05)))
}
}
\seealso{
\code{\link{bvar}}; \code{\link{irf.bvar}}
}
\keyword{BVAR}
\keyword{VAR}
\keyword{fevd}
\keyword{irf}
\keyword{plot}
