% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/95_fitted.R
\name{fitted.bvar}
\alias{fitted.bvar}
\alias{residuals.bvar}
\alias{plot.bvar_resid}
\alias{print.bvar_fitted}
\alias{print.bvar_resid}
\title{Fitted and residual methods for Bayesian VARs}
\usage{
\method{fitted}{bvar}(object, conf_bands = 0.5, ...)

\method{residuals}{bvar}(object, conf_bands = 0.5, ...)

\method{plot}{bvar_resid}(x, vars = NULL, mar = c(2, 2, 2, 0.5), ...)

\method{print}{bvar_fitted}(x, digits = 2L, ...)

\method{print}{bvar_resid}(x, digits = 2L, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{conf_bands}{Numeric vector of desired confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. 0.5 is always included.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}

\item{x}{Object of class \code{bvar_fitted} / \code{bvar_resid}.}

\item{vars}{Optional numeric vector. Used to subset the plot to certain
variables by position. Defaults to \code{NULL}, i.e. all variables.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{digits}{Integer scalar. Fed to \code{\link[base]{round}} and applied to
numeric outputs (i.e. the quantiles).}
}
\value{
Returns a numeric array of class \code{bvar_fitted} /
\code{bvar_resid} with desired values at the specified confidence bands.
}
\description{
Calculates fitted values / resiudals for Bayesian VARs generated via
\code{\link{bvar}}.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Get fitted values and adjust confidence bands to 10\%, 50\% and 90\%
fitted(x, conf_bands = 0.10)

# Get residuals
residuals(x)
}
}
\seealso{
\code{\link{bvar}}
}
