% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.PlotFreqVsConditionalExpectedFrequency}
\alias{mbgcnbd.PlotFreqVsConditionalExpectedFrequency}
\alias{bgcnbd.PlotFreqVsConditionalExpectedFrequency}
\title{(M)BG/CNBD-k Plot Frequency vs. Conditional Expected Frequency}
\usage{
mbgcnbd.PlotFreqVsConditionalExpectedFrequency(
  params,
  T.star,
  cal.cbs,
  x.star,
  censor,
  xlab = "Calibration period transactions",
  ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Conditional Expectation"
)

bgcnbd.PlotFreqVsConditionalExpectedFrequency(
  params,
  T.star,
  cal.cbs,
  x.star,
  censor,
  xlab = "Calibration period transactions",
  ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Conditional Expectation"
)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{T.star}{Length of the holdout period.}

\item{cal.cbs}{Calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ('x'), recency ('t.x') and total time
observed ('T.cal').}

\item{x.star}{Vector of transactions made by each customer in the holdout period.}

\item{censor}{Cutoff point for number of transactions in plot.}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the x axis.}

\item{xticklab}{A vector containing a label for each tick mark on the x axis.}

\item{title}{Title placed on the top-center of the plot.}
}
\value{
Holdout period transaction frequency comparison matrix (actual vs. expected).
}
\description{
Plots the actual and conditional expected number transactions made by
customers in the holdout period, binned according to calibration period
frequencies, and returns this comparison in a matrix.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-09-30")
params <- mbgcnbd.EstimateParameters(cbs, k=2)
mbgcnbd.PlotFreqVsConditionalExpectedFrequency(params, T.star=52, cbs, cbs$x.star, censor=7)
}
}
\seealso{
\code{\link{bgcnbd.PlotFreqVsConditionalExpectedFrequency}}
}
