% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.PlotTrackingInc}
\alias{mcmc.PlotTrackingInc}
\title{Tracking Incremental Transactions Plot for Pareto/GGG, Pareto/NBD (HB) and
Pareto/NBD (Abe)}
\usage{
mcmc.PlotTrackingInc(draws, T.cal, T.tot, actual.inc.tracking.data,
  xlab = "Week", ylab = "Transactions", xticklab = NULL,
  title = "Tracking Weekly Transactions", ymax = NULL,
  sample_size = 10000)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}

\item{T.cal}{A vector to represent customers' calibration period lengths (in
other words, the \code{T.cal} column from a
customer-by-sufficient-statistic matrix). Considering rounding in order to
speed up calculations.}

\item{T.tot}{End of holdout period. Must be a single value, not a vector.}

\item{actual.inc.tracking.data}{A vector containing the incremental number of
repeat transactions made by customers for each period in the total time
period (both calibration and holdout periods).}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the y axis.}

\item{xticklab}{A vector containing a label for each tick mark on the x axis.}

\item{title}{Title placed on the top-center of the plot.}

\item{ymax}{Upper boundary for y axis.}

\item{sample_size}{Sample size for estimating the probability distribution.
See \code{\link{mcmc.ExpectedCumulativeTransactions}}.}
}
\value{
Matrix containing actual and expected incremental repeat
  transactions.
}
\description{
Plots the actual and expected incremental total repeat transactions by all
customers for the calibration and holdout periods, and returns this
comparison in a matrix.
}
\details{
The expected transactions need to be sampled. Due to this sampling, the
return result varies from one call to another. Larger values of
\code{sample_size} will generate more stable results.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
inc <- elog2inc(groceryElog)
param.draws <- pnbd.mcmc.DrawParameters(cbs)
mat <- mcmc.PlotTrackingInc(param.draws,
  T.cal = cbs$T.cal,
  T.tot = max(cbs$T.cal + cbs$T.star),
  actual.inc.tracking.data = inc)
}
}
\seealso{
\code{\link{mcmc.PlotTrackingCum}}
  \code{\link{mcmc.ExpectedCumulativeTransactions}} \code{\link{elog2inc}}
}

