% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.cbs.LL}
\alias{pnbd.cbs.LL}
\title{Pareto/NBD Log-Likelihood}
\usage{
pnbd.cbs.LL(params, cal.cbs, hardie = TRUE)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ("x"), recency ("t.x"), and total time
observed ("T.cal"). Note that recency must be the time between the start of
the calibration period and the customer's last transaction, not the time
between the customer's last transaction and the end of the calibration
period. If your data is compressed (see \code{\link{dc.compress.cbs}}), a
fourth column labelled "custs" (number of customers with a specific
combination of recency, frequency and length of calibration period) will
make this function faster.}

\item{hardie}{if TRUE, use \code{\link{h2f1}} instead of
\code{\link[hypergeo]{hypergeo}}.}
}
\value{
The log-likelihood of the provided data.
}
\description{
Calculates the log-likelihood of the Pareto/NBD model.
}
\examples{
data(cdnowSummary)
cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# random assignment of parameters
params <- c(0.5, 8, 0.7, 10)
# returns the log-likelihood of the given parameters
pnbd.cbs.LL (params, cal.cbs, TRUE)

# compare the speed and results to the following:
cal.cbs.compressed <- dc.compress.cbs(cal.cbs)
pnbd.cbs.LL (params, cal.cbs.compressed, TRUE)
}
\references{
Fader, Peter S., and Bruce G.S. Hardie. "A Note on Deriving the
Pareto/NBD Model and Related Expressions." November. 2005. Web.
\url{http://www.brucehardie.com/notes/008/}
}
\seealso{
\code{\link{pnbd.EstimateParameters}}

\code{\link{pnbd.LL}}
}
