% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btm.R
\name{predict.BTM}
\alias{predict.BTM}
\title{Predict function for a Biterm Topic Model}
\usage{
\method{predict}{BTM}(object, newdata, type = c("sum_b", "sub_w", "mix"), ...)
}
\arguments{
\item{object}{an object of class BTM as returned by \code{\link{BTM}}}

\item{newdata}{a tokenised data frame containing one row per token with 2 columns 
\itemize{
\item the first column is a context identifier (e.g. a tweet id, a document id, a sentence id, an identifier of a survey answer, an identifier of a part of a text)
\item the second column is a column called of type character containing the sequence of words occurring within the context identifier 
}}

\item{type}{character string with the type of prediction. 
Either one of 'sum_b', 'sub_w' or 'mix'. Default is set to 'sum_b' as indicated in the paper, 
indicating to sum over the the expectation of the topic proportions of biterms generated from the document. For the other approaches, please inspect the paper.}

\item{...}{not used}
}
\value{
a matrix containing containing P(z|d) - the probability of the topic given the biterms.\cr
The matrix has one row for each unique doc_id (context identifier)
which contains words part of the dictionary of the BTM model and has K columns, 
one for each topic.
}
\description{
Classify new text alongside the biterm topic model.\cr

To infer the topics in a document, it is assumed that the topic proportions of a document 
is driven by the expectation of the topic proportions of biterms generated from the document.
}
\examples{
library(udpipe)
data("brussels_reviews_anno", package = "udpipe")
x <- subset(brussels_reviews_anno, language == "nl")
x <- subset(x, xpos \%in\% c("NN", "NNP", "NNS"))
x <- x[, c("doc_id", "lemma")]
model  <- BTM(x, k = 5, iter = 5, trace = TRUE)
scores <- predict(model, newdata = x, type = "sum_b")
scores <- predict(model, newdata = x, type = "sub_w")
scores <- predict(model, newdata = x, type = "mix")
head(scores)
}
\references{
Xiaohui Yan, Jiafeng Guo, Yanyan Lan, Xueqi Cheng. A Biterm Topic Model For Short Text. WWW2013,
\url{https://github.com/xiaohuiyan/BTM}, \url{https://github.com/xiaohuiyan/xiaohuiyan.github.io/blob/master/paper/BTM-WWW13.pdf}
}
\seealso{
\code{\link{BTM}}, \code{\link{terms.BTM}}, \code{\link{logLik.BTM}}
}
