% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.BTLLasso.R
\name{response.BTLLasso}
\alias{response.BTLLasso}
\title{Create response object for BTLLasso}
\usage{
response.BTLLasso(response, first.object, second.object, subject = NULL)
}
\arguments{
\item{response}{Vector containing results (binary or ordinal) of single paired
comparisons.}

\item{first.object}{Vector (character or factor, same length as response) indicating the first
object of the respective paired comparison from response.}

\item{second.object}{Vector (character or factor, same length as response) indicating the second
object of the respective paired comparison from response.}

\item{subject}{Vector (character, same length as response) indicating the subject that
generated the respective paired comparison from response.}
}
\value{
Object of class \code{response.BTLLasso}
}
\description{
Create a response object for \code{BTLLasso} and \code{cv.BTLLasso}
}
\author{
Gunther Schauberger\cr \email{gunther@stat.uni-muenchen.de}\cr
\url{http://www.statistik.lmu.de/~schauberger/}
}
\references{
Schauberger, Gunther and Tutz, Gerhard (2015): Modelling
Heterogeneity in Paired Comparison Data - an L1 Penalty Approach with an
Application to Party Preference Data, \emph{Department of Statistics, LMU
Munich}, Technical Report 183
}
\seealso{
\code{\link{BTLLasso}}, \code{\link{cv.BTLLasso}}
}

