% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_bspbss.R
\name{init_bspbss}
\alias{init_bspbss}
\title{Initial values}
\usage{
init_bspbss(
  X,
  coords,
  standardize = TRUE,
  q = 2,
  dens = 0.5,
  ker_par = c(0.05, 20),
  num_eigen = 500,
  noise = 0
)
}
\arguments{
\item{X}{Data matrix with n rows (sample) and p columns (voxel).}

\item{coords}{Cordinate matrix with p rows (voxel) and d columns (dimension).}

\item{standardize}{If TRUE, standarize each row of X.}

\item{q}{Number of latent sources.}

\item{dens}{The initial density level (between 0 and 1) of the latent sources.}

\item{ker_par}{2-dimensional vector (a,b) with a>0, b>0, specifing the parameters in the modified exponetial squared kernel.}

\item{num_eigen}{Number of eigen functions.}

\item{noise}{Gaussian noise added to the initial latent sources, with mean 0 and standard deviation being noise * sd(S0),
where sd(S0) is the standard deviation of the initial latent sources.}
}
\value{
List containing initial values, priors and eigen functions/eigen values of the kernel of the Gaussian process.
}
\description{
Generate initial values, set up priors and perform kernel decomposition
for the MCMC algorithm.
}
\examples{

sim = sim_2Dimage(length = 30, sigma = 5e-4, n = 30, smooth = 6)
ini = init_bspbss(sim$X, sim$coords, q = 3, ker_par = c(0.1,50), num_eigen = 50)

}
