% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLOAF.R
\name{plotLOAF}
\alias{plotLOAF}
\title{plotLOAF}
\usage{
plotLOAF(in_tibble, nsnps_cutoff = NULL, N = NULL, fntsize = 7, verbose = TRUE)
}
\arguments{
\item{in_tibble}{a tibble that is the output of the callRelatedness() function.}

\item{nsnps_cutoff}{the minimum number of overlapping SNPs for which
pairs are removed from the plot. If NULL, default is 500.}

\item{N}{the number of (sorted by increasing PMR) pairs to plot.
Avoids plotting all pairs (many of which are unrelated).}

\item{fntsize}{the fontsize for the x-axis names.}

\item{verbose}{if TRUE, then information about the plotting process is sent
to the console}
}
\value{
a ggplot object
}
\description{
Plots all (sorted by increasing value) observed PMR values with
maximum posterior probability classifications represented by colour
and shape.
Options include a cut off for the minimum number of overlapping SNPs,
the max number of pairs to plot and x-axis font size.
}
\examples{
relatedness_example
plotLOAF(relatedness_example)
}
