% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_plots.R
\name{qq_plot_censored}
\alias{qq_plot_censored}
\title{Plot the quantile-quantile graph for censored data.}
\usage{
qq_plot_censored(fit, thinning_to = 500)
}
\arguments{
\item{fit}{The result of the fit, obtained through the function MixNRMI1 or MixNRMI2, MixNRMI1cens or MixNRMI2cens}

\item{thinning_to}{How many iterations to compute the mean posterior quantiles}
}
\value{
quantile-quantile plot for non censored data.
}
\description{
Plot the quantile-quantile graph for censored data.
}
\details{
This function may be rather slow for many iterations/many data because it relies on numerical inversion of the mixture Cumulative Distribution Function.
set.seed(150520)
data(salinity)
out <- MixNRMI1cens(xleft = salinity$left, xright = salinity$right, extras = TRUE, Nit = 100)
BNPdensity:::qq_plot_censored(out)
}
