% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multMixNRMI.R
\name{multMixNRMI2}
\alias{multMixNRMI2}
\title{Multiple chains of MixNRMI2}
\usage{
multMixNRMI2(x, probs = c(0.025, 0.5, 0.975), Alpha = 1, Kappa = 0,
  Gama = 0.4, distr.k = 1, distr.py0 = 1, distr.pz0 = 2,
  mu.pz0 = 3, sigma.pz0 = sqrt(10), delta = 4, kappa = 2,
  Delta = 2, Meps = 0.01, Nx = 150, Nit = 1500, Pbi = 0.1,
  epsilon = NULL, printtime = TRUE, extras = TRUE, nchains = 4,
  parallel = FALSE, seed = 1, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Numeric vector. Data set to which the density is fitted.}

\item{probs}{Numeric vector. Desired quantiles of the density estimates.}

\item{Alpha}{Numeric constant. Total mass of the centering measure. See details.}

\item{Kappa}{Numeric positive constant. See details.}

\item{Gama}{Numeric constant. 0 <= Gama <= 1. See details.}

\item{distr.k}{Integer number identifying the mixture kernel: 1 = Normal; 2 = Gamma; 3 = Beta; 4 = Double Exponential; 5 = Lognormal.}

\item{distr.py0}{Integer number identifying the centering measure for locations: 1 = Normal; 2 = Gamma; 3 = Beta.}

\item{distr.pz0}{Integer number identifying the centering measure for scales: 2 = Gamma. For more options use MixNRMI2cens.}

\item{mu.pz0}{Numeric constant. Prior mean of the centering measure for scales.}

\item{sigma.pz0}{Numeric constant. Prior standard deviation of the centering measure for scales.}

\item{delta}{Numeric positive constant. Metropolis-Hastings proposal variation coefficient for sampling the scales.}

\item{kappa}{Numeric positive constant. Metropolis-Hastings proposal variation coefficient for sampling the location parameters.}

\item{Delta}{Numeric positive constant. Metropolis-Hastings proposal variation coefficient for sampling the latent U.}

\item{Meps}{Numeric constant. Relative error of the jump sizes in the continuous component of the process. Smaller values imply larger number of jumps.}

\item{Nx}{Integer constant. Number of grid points for the evaluation of the density estimate.}

\item{Nit}{Integer constant. Number of MCMC iterations.}

\item{Pbi}{Numeric constant. Burn-in period proportion of Nit.}

\item{epsilon}{Numeric constant. Extension to the evaluation grid range. See details.}

\item{printtime}{Logical. If TRUE, prints out the execution time.}

\item{extras}{Logical. If TRUE, gives additional objects: means, sigmas, weights and Js.}

\item{nchains}{The number of chains to run.}

\item{parallel}{Whether to run the chains in parallel. Only works on UNIX-like systems as it rests on Fork parallelism}

\item{seed}{Random seed for the run. Each chain has an independent seed based on the value of `seed`}

\item{ncores}{Number of cores for the parallel run. Defaults to parallel::detectCores(), i.e. the maximum number of cores detected by R on your system.}
}
\value{
a list containing the multiple fits.
}
\description{
Multiple chains of MixNRMI2
}
\examples{
data(acidity)
multMixNRMI2(acidity, parallel = TRUE, Nit = 10, ncores = 2)
}
