% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focalSpecies.R
\name{communityMatrix}
\alias{communityMatrix}
\title{Create a community matrix}
\usage{
communityMatrix(x, sampleUnit = "observation")
}
\arguments{
\item{x}{an object of class \sQuote{SummarizeBirds}.}

\item{sampleUnit}{an string specifying the sample unit within a grid cell.
Options are \dQuote{observation} (default) or \dQuote{visit}.
If spillOver=TRUE and visits are defined by locality, it may happen that some
species observations are counted in more than one grid cell.}
}
\value{
a \code{matrix} with counts of observations or visits for each species on each non-empty grid cell.
}
\description{
A function that counts the number of observations or visits per grid cell for all species.
}
\examples{
\donttest{
grid <- makeGrid(searchPolygon, gridSize = 10)
SB <- summarizeBirds(organizeBirds(bombusObsShort), grid=grid)
CM <- communityMatrix(SB, sampleUnit="visit")
}
}
\seealso{
\code{\link{summarizeBirds}}, \code{\link{exportBirds}}
}
