% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_skinny_ranges_to_richness_raster}
\alias{BIEN_ranges_skinny_ranges_to_richness_raster}
\title{Build a richness raster from a skinny range file}
\usage{
BIEN_ranges_skinny_ranges_to_richness_raster(skinny_ranges, raster)
}
\arguments{
\item{skinny_ranges}{A matrix output by the function "BIEN_ranges_skinny" or equivalent methods.}

\item{raster}{The raster that was used in building the skinny_ranges matrix.}
}
\value{
Raster
}
\description{
BIEN_ranges_skinny_ranges_to_richness_raster takes in "skinny" range data and converts it to a richness raster.
}
\examples{
\dontrun{


template_raster <- terra::rast(
  crs = "+proj=laea +lat_0=15 +lon_0=-80 +x_0=0 +y_0=0 +datum=WGS84 
  +units=m +no_defs +ellps=WGS84 +towgs84=0,0,0",
  ext = ext(c(-5261554, 5038446, -7434988, 7165012 )),
  resolution =  c(100000, 100000))

#Download ranges and convert to a "skinny" format
skinny_ranges <- BIEN_ranges_shapefile_to_skinny(
directory = BIEN_ranges_species_bulk(species = c("Acer rubrum"), 
raster = template_raster)

#Convert from skinny format to richness raster                                                 
richness_raster<- BIEN_ranges_skinny_ranges_to_richness_raster(
 skinny_ranges = skinny_ranges,raster = template_raster)
 
 plot(richness_raster)
}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_box}()},
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_intersect_species}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_sf}()},
\code{\link{BIEN_ranges_shapefile_to_skinny}()},
\code{\link{BIEN_ranges_species_bulk}()},
\code{\link{BIEN_ranges_species}()}
}
\concept{range functions}
