% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_plot_sf}
\alias{BIEN_plot_sf}
\title{Download plot data from specified sf object.}
\usage{
BIEN_plot_sf(
  sf,
  cultivated = FALSE,
  new.world = NULL,
  all.taxonomy = FALSE,
  native.status = FALSE,
  natives.only = TRUE,
  political.boundaries = TRUE,
  collection.info = FALSE,
  all.metadata = FALSE,
  ...
)
}
\arguments{
\item{sf}{An object of class sf.  Note that the projection must be WGS84.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A dataframe containing all plot data from within the specified sf polygon.
}
\description{
BIEN_plot_sf downloads all plot data falling within a supplied sf polygon.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php
}
\examples{
\dontrun{
library(sf)

BIEN_ranges_species("Carnegiea gigantea") #saves ranges to the current working directory

sf <- st_read(dsn = ".",
              layer = "Carnegiea_gigantea")

saguaro_plot_data <- BIEN_plot_sf(sf = sf)
}
}
\seealso{
Other plot functions: 
\code{\link{BIEN_plot_country}()},
\code{\link{BIEN_plot_dataset}()},
\code{\link{BIEN_plot_datasource}()},
\code{\link{BIEN_plot_list_datasource}()},
\code{\link{BIEN_plot_list_sampling_protocols}()},
\code{\link{BIEN_plot_metadata}()},
\code{\link{BIEN_plot_name}()},
\code{\link{BIEN_plot_sampling_protocol}()},
\code{\link{BIEN_plot_state}()}
}
\concept{plot functions}
