% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_taxonomy_species}
\alias{BIEN_taxonomy_species}
\title{Extract taxonomic information for species}
\usage{
BIEN_taxonomy_species(species, print.query = FALSE, ...)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing taxonomic information for the specified species.
}
\description{
BIEN_taxonomy_species downloads a dataframe of all taxonomic information for given species.
}
\examples{
\dontrun{
BIEN_taxonomy_species("Cannabis sativa")
species_vector<-c("Acer nigrum","Cannabis sativa")
BIEN_taxonomy_species(species_vector)}
}
\seealso{
Other taxonomy functions: \code{\link{BIEN_taxonomy_family}},
  \code{\link{BIEN_taxonomy_genus}}
}

